/*
 * Decompiled with CFR 0.152.
 */
package com.reucon.openfire.plugins.userstatus;

import com.reucon.openfire.plugins.userstatus.DefaultPersistenceManager;
import com.reucon.openfire.plugins.userstatus.PersistenceManager;
import com.reucon.openfire.plugins.userstatus.PhpBB3PersistenceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.event.SessionEventDispatcher;
import org.jivesoftware.openfire.event.SessionEventListener;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.openfire.user.PresenceEventDispatcher;
import org.jivesoftware.openfire.user.PresenceEventListener;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.xmpp.packet.JID;
import org.xmpp.packet.Presence;

public class UserStatusPlugin
implements Plugin,
PropertyEventListener,
SessionEventListener,
PresenceEventListener,
PersistenceManager {
    public static final String HISTORY_DAYS_PROPERTY = "user-status.historyDays";
    public static final int DEFAULT_HISTORY_DAYS = -1;
    private Collection<PersistenceManager> persistenceManagers;

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        int historyDays = JiveGlobals.getIntProperty((String)HISTORY_DAYS_PROPERTY, (int)-1);
        PropertyEventDispatcher.addListener((PropertyEventListener)this);
        this.persistenceManagers = new ArrayList<PersistenceManager>();
        this.persistenceManagers.add(new DefaultPersistenceManager());
        try {
            Class.forName("com.reucon.openfire.phpbb3.PhpBB3AuthProvider");
            this.persistenceManagers.add(new PhpBB3PersistenceManager());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.setAllOffline();
        this.setHistoryDays(historyDays);
        for (ClientSession session : SessionManager.getInstance().getSessions()) {
            this.sessionCreated((Session)session);
        }
        SessionEventDispatcher.addListener((SessionEventListener)this);
        PresenceEventDispatcher.addListener((PresenceEventListener)this);
    }

    public void destroyPlugin() {
        PresenceEventDispatcher.removeListener((PresenceEventListener)this);
        SessionEventDispatcher.removeListener((SessionEventListener)this);
    }

    public static boolean isRegisteredLocalUser(JID user) {
        if (XMPPServer.getInstance().isLocal(user)) {
            try {
                XMPPServer.getInstance().getUserManager().getUser(user.getNode());
                return true;
            }
            catch (UserNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    public void sessionCreated(Session session) {
        if (!UserStatusPlugin.isRegisteredLocalUser(session.getAddress())) {
            return;
        }
        if (!UserStatusPlugin.isRegisteredLocalUser(session.getAddress())) {
            return;
        }
        this.setOnline(session);
    }

    public void sessionDestroyed(Session session) {
        if (!UserStatusPlugin.isRegisteredLocalUser(session.getAddress())) {
            return;
        }
        this.setOffline(session, new Date());
    }

    public void anonymousSessionCreated(Session session) {
    }

    public void anonymousSessionDestroyed(Session session) {
    }

    public void resourceBound(Session session) {
    }

    public void availableSession(ClientSession session, Presence presence) {
        this.updatePresence(session, presence);
    }

    public void unavailableSession(ClientSession session, Presence presence) {
        this.updatePresence(session, presence);
    }

    public void presencePriorityChanged(ClientSession session, Presence presence) {
    }

    public void presenceChanged(ClientSession session, Presence presence) {
        this.updatePresence(session, presence);
    }

    public void subscribedToPresence(JID subscriberJID, JID authorizerJID) {
    }

    public void unsubscribedToPresence(JID unsubscriberJID, JID recipientJID) {
    }

    public void propertySet(String property, Map<String, Object> params) {
        Object value;
        if (HISTORY_DAYS_PROPERTY.equals(property) && (value = params.get("value")) != null) {
            try {
                this.setHistoryDays(Integer.valueOf(value.toString()));
            }
            catch (NumberFormatException e) {
                this.setHistoryDays(-1);
            }
            this.deleteOldHistoryEntries();
        }
    }

    public void propertyDeleted(String property, Map<String, Object> params) {
        if (HISTORY_DAYS_PROPERTY.equals(property)) {
            this.setHistoryDays(-1);
            this.deleteOldHistoryEntries();
        }
    }

    public void xmlPropertySet(String property, Map<String, Object> params) {
    }

    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
    }

    private void updatePresence(ClientSession session, Presence presence) {
        String presenceText;
        Object con = null;
        Object pstmt = null;
        if (!UserStatusPlugin.isRegisteredLocalUser(session.getAddress())) {
            return;
        }
        if (Presence.Type.unavailable.equals((Object)presence.getType())) {
            presenceText = presence.getType().toString();
        } else if (presence.getShow() != null) {
            presenceText = presence.getShow().toString();
        } else if (presence.isAvailable()) {
            presenceText = "available";
        } else {
            return;
        }
        this.setPresence((Session)session, presenceText);
    }

    @Override
    public void setHistoryDays(int historyDays) {
        for (PersistenceManager pm : this.persistenceManagers) {
            pm.setHistoryDays(historyDays);
        }
    }

    @Override
    public void setAllOffline() {
        for (PersistenceManager pm : this.persistenceManagers) {
            pm.setAllOffline();
        }
    }

    @Override
    public void setOnline(Session session) {
        for (PersistenceManager pm : this.persistenceManagers) {
            pm.setOnline(session);
        }
    }

    @Override
    public void setOffline(Session session, Date logoffDate) {
        for (PersistenceManager pm : this.persistenceManagers) {
            pm.setOffline(session, logoffDate);
        }
    }

    @Override
    public void setPresence(Session session, String presenceText) {
        for (PersistenceManager pm : this.persistenceManagers) {
            pm.setPresence(session, presenceText);
        }
    }

    @Override
    public void deleteOldHistoryEntries() {
        for (PersistenceManager pm : this.persistenceManagers) {
            pm.deleteOldHistoryEntries();
        }
    }
}

