/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.service;

import javax.annotation.PostConstruct;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.entity.UserGroupsEntity;
import org.jivesoftware.openfire.exceptions.ServiceException;
import org.jivesoftware.openfire.plugin.UserServicePluginNG;

@Path(value="userService/users/{username}/groups")
public class UserGroupService {
    private UserServicePluginNG plugin;

    @PostConstruct
    public void init() {
        this.plugin = UserServicePluginNG.getInstance();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public UserGroupsEntity getUserGroups(@PathParam(value="username") String username) throws ServiceException {
        return new UserGroupsEntity(this.plugin.getUserGroups(username));
    }

    @POST
    public Response addUserToGroups(@PathParam(value="username") String username, UserGroupsEntity userGroupsEntity) throws ServiceException {
        this.plugin.addUserToGroups(username, userGroupsEntity);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    public Response deleteUserFromGroups(@PathParam(value="username") String username, UserGroupsEntity userGroupsEntity) throws ServiceException {
        this.plugin.deleteUserFromGroups(username, userGroupsEntity);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

