/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.exceptions.ServiceException;

public class PropertyDAO {
    private static final String LOAD_PROPERTY = "SELECT username FROM ofUserProp WHERE name=? AND propValue=?";
    private static final String LOAD_PROPERTY_BY_KEY = "SELECT username FROM ofUserProp WHERE name=?";

    public static List<String> getUsernameByProperty(String propertyName, String propertyValue) throws ServiceException {
        ArrayList<String> usernames = new ArrayList<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            if (propertyValue != null) {
                pstmt = con.prepareStatement(LOAD_PROPERTY);
                pstmt.setString(1, propertyName);
                pstmt.setString(2, propertyValue);
            } else {
                pstmt = con.prepareStatement(LOAD_PROPERTY_BY_KEY);
                pstmt.setString(1, propertyName);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                usernames.add(rs.getString(1));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new ServiceException("Could not get username by property", propertyName, "PropertyNotFoundException", Response.Status.NOT_FOUND, sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return usernames;
    }
}

