/*
 * Decompiled with CFR 0.152.
 */
package org.tiki.tikitoken;

import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiki.tikitoken.TikiTokenQuery;

public class TikiTokenSaslServer
implements SaslServer {
    private static final Logger Log = LoggerFactory.getLogger(TikiTokenSaslServer.class);
    public static final String MECHANISM_NAME = "TIKITOKEN";
    private String authorizationID = null;
    private State state = State.PRE_INITIAL_RESPONSE;

    @Override
    public String getMechanismName() {
        return MECHANISM_NAME;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        Log.trace("Evaluating new response...");
        if (this.isComplete()) {
            throw new IllegalStateException("TIKITOKEN authentication was already completed.");
        }
        Log.trace("Current state: {}", (Object)this.state);
        switch (this.state) {
            case POST_INITIAL_RESPONSE: {
                if (response.length == 0) {
                    this.state = State.COMPLETED;
                    throw new SaslException("The TIKITOKEN SASL mechanism expects response data in either the initial or second client response. Neither had any data.");
                }
            }
            case PRE_INITIAL_RESPONSE: {
                if (response.length == 0) {
                    this.state = State.POST_INITIAL_RESPONSE;
                    return null;
                }
                this.state = State.COMPLETED;
                Log.trace("Parsing data from client response...");
                String data = new String(response, StandardCharsets.UTF_8);
                StringTokenizer tokens = new StringTokenizer(data, "\u0000");
                if (tokens.countTokens() != 2) {
                    throw new SaslException("Exactly two NUL (U+0000) character-separated values are expected (a username, followed by a Tiki access token). Instead " + tokens.countTokens() + " were found.");
                }
                String username = tokens.nextToken();
                String tikiToken = tokens.nextToken();
                Log.trace("Parsed data from client response for user '{}'. Verifying Tiki token...", (Object)username);
                TikiTokenQuery query = new TikiTokenQuery(username, tikiToken);
                if (!query.isValid()) {
                    throw new SaslException("Tiki token based authentication failed for: " + username);
                }
                Log.debug("Authentication successful for user '{}'!", (Object)username);
                this.authorizationID = username;
                return null;
            }
        }
        throw new IllegalStateException("Instance is in an unrecognized state (please report this incident as a bug in class: " + this.getClass().getCanonicalName() + "). Unrecognized value: " + (Object)((Object)this.state));
    }

    @Override
    public boolean isComplete() {
        return this.state == State.COMPLETED;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw new IllegalStateException("TIKITOKEN authentication has not completed.");
        }
        return this.authorizationID;
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.isComplete()) {
            throw new IllegalStateException("TIKITOKEN authentication has not completed.");
        }
        if ("javax.security.sasl.qop".equals(propName)) {
            return "auth";
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
        this.state = null;
        this.authorizationID = null;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("TIKITOKEN authentication has not completed.");
        }
        throw new IllegalStateException("TIKITOKEN supports neither integrity nor privacy.");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("TIKITOKEN authentication has not completed.");
        }
        throw new IllegalStateException("TIKITOKEN supports neither integrity nor privacy.");
    }

    private static enum State {
        PRE_INITIAL_RESPONSE,
        POST_INITIAL_RESPONSE,
        COMPLETED;

    }
}

