/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.openfire.PresenceRouter;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.interceptor.InterceptorManager;
import org.jivesoftware.openfire.interceptor.PacketInterceptor;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.util.JiveGlobals;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class SubscriptionPlugin
implements Plugin {
    public static final String DISABLED = "disabled";
    public static final String ACCEPT = "accept";
    public static final String REJECT = "reject";
    public static final String LOCAL = "local";
    public static final String ALL = "all";
    private static final String SUBSCRIPTION_TYPE = "plugin.subscription.type";
    private static final String SUBSCRIPTION_LEVEL = "plugin.subscription.level";
    private static final String WHITE_LIST = "plugin.subscription.whiteList";
    private List<String> whiteList = new ArrayList<String>();
    private SuscriptionPacketInterceptor interceptor = new SuscriptionPacketInterceptor();
    private PresenceRouter router;
    private String serverName;

    public SubscriptionPlugin() {
        XMPPServer server = XMPPServer.getInstance();
        this.router = server.getPresenceRouter();
        this.serverName = server.getServerInfo().getXMPPDomain();
        String list = JiveGlobals.getProperty((String)WHITE_LIST);
        if (list != null) {
            this.whiteList.addAll(this.csvToList(list));
        }
    }

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        InterceptorManager.getInstance().addInterceptor((PacketInterceptor)this.interceptor);
    }

    public void destroyPlugin() {
        InterceptorManager.getInstance().removeInterceptor((PacketInterceptor)this.interceptor);
        this.interceptor = null;
        this.router = null;
        this.serverName = null;
        this.whiteList = null;
    }

    public void setSubscriptionType(String type) {
        JiveGlobals.setProperty((String)SUBSCRIPTION_TYPE, (String)type);
    }

    public String getSubscriptionType() {
        return JiveGlobals.getProperty((String)SUBSCRIPTION_TYPE, (String)DISABLED);
    }

    public void setSubscriptionLevel(String level) {
        JiveGlobals.setProperty((String)SUBSCRIPTION_LEVEL, (String)level);
    }

    public String getSubscriptionLevel() {
        return JiveGlobals.getProperty((String)SUBSCRIPTION_LEVEL, (String)LOCAL);
    }

    public Collection<String> getWhiteListUsers() {
        Collections.sort(this.whiteList);
        return this.whiteList;
    }

    public void addWhiteListUser(String user) {
        if (!this.whiteList.contains(user.trim().toLowerCase())) {
            this.whiteList.add(user.trim().toLowerCase());
            JiveGlobals.setProperty((String)WHITE_LIST, (String)this.listToCSV(this.whiteList));
        }
    }

    public void removeWhiteListUser(String user) {
        this.whiteList.remove(user.trim().toLowerCase());
        if (this.whiteList.size() == 0) {
            JiveGlobals.deleteProperty((String)WHITE_LIST);
        } else {
            JiveGlobals.setProperty((String)WHITE_LIST, (String)this.listToCSV(this.whiteList));
        }
    }

    private String listToCSV(List<String> list) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            sb.append(s);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private List<String> csvToList(String csv) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(csv.split(",")));
        return list;
    }

    private class SuscriptionPacketInterceptor
    implements PacketInterceptor {
        private SuscriptionPacketInterceptor() {
        }

        public void interceptPacket(Packet packet, Session session, boolean incoming, boolean processed) throws PacketRejectedException {
            Presence presencePacket;
            Presence.Type presenceType;
            String type = SubscriptionPlugin.this.getSubscriptionType();
            if (type.equals(SubscriptionPlugin.DISABLED)) {
                return;
            }
            if (packet instanceof Presence && !incoming && !processed && (presenceType = (presencePacket = (Presence)packet).getType()) != null && presenceType.equals((Object)Presence.Type.subscribe)) {
                JID toJID = presencePacket.getTo();
                JID fromJID = presencePacket.getFrom();
                String toNode = toJID.getNode();
                if (SubscriptionPlugin.this.whiteList.contains(toNode)) {
                    return;
                }
                if (type.equals(SubscriptionPlugin.ACCEPT)) {
                    this.acceptSubscription(toJID, fromJID);
                }
                if (type.equals(SubscriptionPlugin.REJECT)) {
                    this.rejectSubscription(toJID, fromJID);
                }
            }
        }

        private void acceptSubscription(JID toJID, JID fromJID) throws PacketRejectedException {
            if (SubscriptionPlugin.this.getSubscriptionLevel().equals(SubscriptionPlugin.LOCAL)) {
                String toDomain = toJID.getDomain();
                String fromDomain = fromJID.getDomain();
                if (!toDomain.equals(SubscriptionPlugin.this.serverName) || !fromDomain.equals(SubscriptionPlugin.this.serverName)) {
                    return;
                }
            }
            Presence presence = new Presence();
            presence.setType(Presence.Type.subscribed);
            presence.setTo(fromJID);
            presence.setFrom(toJID);
            SubscriptionPlugin.this.router.route(presence);
            throw new PacketRejectedException();
        }

        private void rejectSubscription(JID toJID, JID fromJID) throws PacketRejectedException {
            String resource;
            if (SubscriptionPlugin.this.getSubscriptionLevel().equals(SubscriptionPlugin.LOCAL)) {
                String toDomain = toJID.getDomain();
                String fromDomain = fromJID.getDomain();
                if (toDomain.equals(SubscriptionPlugin.this.serverName) && fromDomain.equals(SubscriptionPlugin.this.serverName)) {
                    return;
                }
            }
            Presence presence = new Presence();
            presence.setType(Presence.Type.unsubscribed);
            if (JiveGlobals.getBooleanProperty((String)"plugin.subscription.sparkCheck", (boolean)false) && (resource = fromJID.getResource()) != null && resource.equalsIgnoreCase("Spark")) {
                presence.setType(Presence.Type.unsubscribed);
            }
            presence.setTo(fromJID);
            presence.setFrom(toJID);
            SubscriptionPlugin.this.router.route(presence);
            throw new PacketRejectedException();
        }
    }
}

