/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.stun;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class StunServerAddress {
    private String server;
    private String port;

    public StunServerAddress(String server, String port) {
        this.server = server;
        this.port = port;
    }

    public String getServer() {
        return this.server;
    }

    public String getPort() {
        return this.port;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StunServerAddress) {
            StunServerAddress other = (StunServerAddress)obj;
            if (this.getPort().equals(other.getPort())) {
                if (this.getServer().equals(other.getServer())) {
                    return true;
                }
                try {
                    InetAddress addr0 = InetAddress.getByName(this.getServer());
                    InetAddress addr1 = InetAddress.getByName(other.getServer());
                    return addr0.getHostAddress().equals(addr1.getHostAddress());
                }
                catch (UnknownHostException e) {
                    return false;
                }
            }
        }
        return false;
    }
}

