/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.stun;

import de.javawi.jstun.test.demo.StunServer;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.stun.StunServerAddress;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.PacketError;

public class STUNService
implements Plugin {
    private static final Logger Log = LoggerFactory.getLogger(STUNService.class);
    public static final String STUN_ADDRESS_PRIMARY = "stun.address.primary";
    public static final String STUN_ADDRESS_SECONDARY = "stun.address.secondary";
    public static final String STUN_PORT_PRIMARY = "stun.port.primary";
    public static final String STUN_PORT_SECONDARY = "stun.port.secondary";
    private static final String ELEMENT_NAME = "stun";
    private static final String NAMESPACE = "google:jingleinfo";
    private static final String DEFAULT_EXTERNAL_ADDRESSES = "stun.xten.net:3478;jivesoftware.com:3478;igniterealtime.org:3478;stun.fwdnet.net:3478";
    private IQHandler stunIQHandler;
    private StunServer stunServer = null;
    private boolean enabled = false;
    private boolean localEnabled = false;
    private String primaryAddress = null;
    private String secondaryAddress = null;
    private int primaryPort;
    private int secondaryPort;
    private List<StunServerAddress> externalServers = null;

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        this.enabled = JiveGlobals.getBooleanProperty((String)"stun.enabled", (boolean)true);
        this.primaryAddress = JiveGlobals.getProperty((String)STUN_ADDRESS_PRIMARY);
        this.secondaryAddress = JiveGlobals.getProperty((String)STUN_ADDRESS_SECONDARY);
        String addresses = JiveGlobals.getProperty((String)"stun.external.addresses");
        if (addresses == null) {
            addresses = DEFAULT_EXTERNAL_ADDRESSES;
        }
        this.externalServers = this.getStunServerAddresses(addresses);
        this.primaryPort = JiveGlobals.getIntProperty((String)STUN_PORT_PRIMARY, (int)3478);
        this.secondaryPort = JiveGlobals.getIntProperty((String)STUN_PORT_SECONDARY, (int)3479);
        this.localEnabled = JiveGlobals.getBooleanProperty((String)"stun.local.enabled", (boolean)false);
        if (this.localEnabled && (this.primaryAddress == null || this.secondaryAddress == null)) {
            Log.warn("STUN server cannot be enabled. Primary and secondary addresses must be defined.");
            this.localEnabled = false;
        }
        this.start();
        PropertyEventDispatcher.addListener((PropertyEventListener)new PropertyEventListener(){

            public void propertySet(String property, Map<String, Object> params) {
                if (property.equals("stun.enabled")) {
                    boolean oldValue = STUNService.this.enabled;
                    STUNService.this.enabled = JiveGlobals.getBooleanProperty((String)"stun.enabled", (boolean)true);
                    if (STUNService.this.enabled && !oldValue) {
                        STUNService.this.startSTUNService();
                    } else if (!STUNService.this.enabled && oldValue) {
                        STUNService.this.stop();
                    }
                } else if (property.equals("stun.local.enabled")) {
                    STUNService.this.localEnabled = JiveGlobals.getBooleanProperty((String)"stun.local.enabled", (boolean)false);
                } else if (property.equals(STUNService.STUN_ADDRESS_PRIMARY)) {
                    STUNService.this.primaryAddress = JiveGlobals.getProperty((String)STUNService.STUN_ADDRESS_PRIMARY);
                } else if (property.equals(STUNService.STUN_ADDRESS_SECONDARY)) {
                    STUNService.this.secondaryAddress = JiveGlobals.getProperty((String)STUNService.STUN_ADDRESS_SECONDARY);
                } else if (property.equals(STUNService.STUN_PORT_PRIMARY)) {
                    STUNService.this.primaryPort = JiveGlobals.getIntProperty((String)STUNService.STUN_PORT_PRIMARY, (int)3478);
                } else if (property.equals(STUNService.STUN_PORT_SECONDARY)) {
                    STUNService.this.secondaryPort = JiveGlobals.getIntProperty((String)STUNService.STUN_PORT_SECONDARY, (int)3479);
                }
            }

            public void propertyDeleted(String property, Map<String, Object> params) {
                if (property.equals("stun.enabled")) {
                    STUNService.this.enabled = true;
                } else if (property.equals("stun.local.enabled")) {
                    STUNService.this.localEnabled = false;
                }
            }

            public void xmlPropertySet(String property, Map<String, Object> params) {
            }

            public void xmlPropertyDeleted(String property, Map<String, Object> params) {
            }
        });
    }

    public void destroyPlugin() {
        this.stop();
    }

    public void start() {
        if (this.isEnabled()) {
            this.startSTUNService();
            if (this.isLocalEnabled()) {
                this.startLocalServer();
            }
        }
    }

    private void startLocalServer() {
        try {
            InetAddress primary = InetAddress.getByName(this.primaryAddress);
            InetAddress secondary = InetAddress.getByName(this.secondaryAddress);
            if (primary != null && secondary != null) {
                this.stunServer = new StunServer(this.primaryPort, primary, this.secondaryPort, secondary);
                this.stunServer.start();
            } else {
                this.setLocalEnabled(false);
            }
        }
        catch (SocketException e) {
            Log.error("Disabling STUN server", (Throwable)e);
            this.setLocalEnabled(false);
        }
        catch (UnknownHostException e) {
            Log.error("Disabling STUN server", (Throwable)e);
            this.setLocalEnabled(false);
        }
    }

    private void startSTUNService() {
        XMPPServer server = XMPPServer.getInstance();
        server.getIQDiscoInfoHandler().addServerFeature(NAMESPACE);
        this.stunIQHandler = new STUNIQHandler();
        server.getIQRouter().addHandler(this.stunIQHandler);
    }

    private void stopSTUNService() {
        XMPPServer server = XMPPServer.getInstance();
        server.getIQDiscoInfoHandler().removeServerFeature(NAMESPACE);
        if (this.stunIQHandler != null) {
            server.getIQRouter().removeHandler(this.stunIQHandler);
            this.stunIQHandler = null;
        }
    }

    public void stop() {
        this.enabled = false;
        this.stopSTUNService();
        this.stopLocal();
    }

    private void stopLocal() {
        if (this.stunServer != null) {
            this.stunServer.stop();
        }
        this.stunServer = null;
    }

    public List<StunServerAddress> getExternalServers() {
        return this.externalServers;
    }

    public void addExternalServer(String server, String port) {
        this.externalServers.add(new StunServerAddress(server, port));
        String property = "";
        for (StunServerAddress stunServerAddress : this.externalServers) {
            if (!property.equals("")) {
                property = property + ";";
            }
            property = property + stunServerAddress.getServer() + ":" + stunServerAddress.getPort();
        }
        JiveGlobals.setProperty((String)"stun.external.addresses", (String)property);
    }

    public void removeExternalServer(int index) {
        this.externalServers.remove(index);
        String property = "";
        for (StunServerAddress stunServerAddress : this.externalServers) {
            if (!property.equals("")) {
                property = property + ";";
            }
            property = property + stunServerAddress.getServer() + ":" + stunServerAddress.getPort();
        }
        JiveGlobals.setProperty((String)"stun.external.addresses", (String)property);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLocalEnabled() {
        return this.localEnabled;
    }

    public void setEnabled(boolean enabled, boolean localEnabled) {
        if (enabled && !this.enabled) {
            this.startSTUNService();
            if (this.isLocalEnabled()) {
                this.startLocalServer();
            }
        } else {
            this.stopSTUNService();
        }
        this.enabled = enabled;
        this.localEnabled = localEnabled;
    }

    public void setLocalEnabled(boolean enabled) {
        this.localEnabled = enabled;
        if (this.isLocalEnabled()) {
            this.startLocalServer();
        } else {
            this.stopLocal();
        }
    }

    public int getSecondaryPort() {
        return this.secondaryPort;
    }

    public int getPrimaryPort() {
        return this.primaryPort;
    }

    public String getSecondaryAddress() {
        return this.secondaryAddress;
    }

    public String getPrimaryAddress() {
        return this.primaryAddress;
    }

    public List<InetAddress> getAddresses() {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> iaddresses = iface.getInetAddresses();
                while (iaddresses.hasMoreElements()) {
                    InetAddress iaddress = iaddresses.nextElement();
                    if (iaddress.isLoopbackAddress() || iaddress.isLinkLocalAddress()) continue;
                    list.add(iaddress);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private List<StunServerAddress> getStunServerAddresses(String addresses) {
        String[] servers;
        ArrayList<StunServerAddress> list = new ArrayList<StunServerAddress>();
        if (addresses.equals("")) {
            return list;
        }
        for (String server : servers = addresses.split(";")) {
            String[] address = server.split(":");
            StunServerAddress aux = new StunServerAddress(address[0], address[1]);
            if (list.contains(aux)) continue;
            list.add(aux);
        }
        return list;
    }

    private class STUNIQHandler
    extends IQHandler {
        public STUNIQHandler() {
            super(STUNService.ELEMENT_NAME);
        }

        public IQ handleIQ(IQ iq) throws UnauthorizedException {
            IQ reply = IQ.createResultIQ((IQ)iq);
            Element childElement = iq.getChildElement();
            String namespace = childElement.getNamespaceURI();
            Element childElementCopy = iq.getChildElement().createCopy();
            reply.setChildElement(childElementCopy);
            if (STUNService.NAMESPACE.equals(namespace)) {
                if (STUNService.this.isEnabled()) {
                    Element stun = childElementCopy.addElement(STUNService.ELEMENT_NAME);
                    if (STUNService.this.isLocalEnabled()) {
                        StunServerAddress local = new StunServerAddress(STUNService.this.primaryAddress, String.valueOf(STUNService.this.primaryPort));
                        if (!STUNService.this.externalServers.contains(local)) {
                            Element server = stun.addElement("server");
                            server.addAttribute("host", local.getServer());
                            server.addAttribute("udp", local.getPort());
                        }
                    }
                    for (StunServerAddress stunServerAddress : STUNService.this.externalServers) {
                        Element server = stun.addElement("server");
                        server.addAttribute("host", stunServerAddress.getServer());
                        server.addAttribute("udp", stunServerAddress.getPort());
                    }
                    try {
                        String ip = this.sessionManager.getSession(iq.getFrom()).getHostAddress();
                        if (ip != null) {
                            Element publicIp = childElementCopy.addElement("publicip");
                            publicIp.addAttribute("ip", ip);
                        }
                    }
                    catch (UnknownHostException e) {
                        Log.error(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                reply.setError(PacketError.Condition.service_unavailable);
            }
            try {
                Log.debug("STUNService: RETURNED:" + reply.toXML());
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
            return reply;
        }

        public IQHandlerInfo getInfo() {
            return new IQHandlerInfo(STUNService.ELEMENT_NAME, STUNService.NAMESPACE);
        }
    }
}

