/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sip.tester.stack;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransportNotSupportedException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.jivesoftware.openfire.sip.tester.Log;
import org.jivesoftware.openfire.sip.tester.comm.CommunicationsException;
import org.jivesoftware.openfire.sip.tester.comm.CommunicationsListener;
import org.jivesoftware.openfire.sip.tester.security.SipSecurityManager;
import org.jivesoftware.openfire.sip.tester.security.UserCredentials;
import org.jivesoftware.openfire.sip.tester.stack.RegisterProcessing;
import org.jivesoftware.openfire.sip.tester.stack.RegistrationEvent;
import org.jivesoftware.openfire.sip.tester.stack.SIPConfig;
import org.jivesoftware.openfire.sip.tester.stack.SipCommRouter;

public class SipManager
implements SipListener {
    protected static final int RETRY_OBJECT_DELETES = 10;
    protected static final long RETRY_OBJECT_DELETES_AFTER = 500L;
    protected static final String DEFAULT_TRANSPORT = "udp";
    protected InetAddress localAddress = null;
    public SipFactory sipFactory;
    public AddressFactory addressFactory;
    public HeaderFactory headerFactory;
    public MessageFactory messageFactory;
    SipStack sipStack;
    public boolean isBusy = true;
    ListeningPoint listeningPoint;
    public SipProvider sipProvider;
    private InetSocketAddress publicIpAddress = null;
    protected String sipStackPath = "gov.nist";
    protected String currentlyUsedURI = null;
    protected String displayName = null;
    protected String transport = null;
    protected String registrarAddress = null;
    protected int localPort = -1;
    protected int registrarPort = -1;
    protected int registrationsExpiration = -1;
    protected String registrarTransport = null;
    protected String stackAddress = null;
    protected String stackName = "JiveSIP";
    protected FromHeader fromHeader = null;
    protected ContactHeader contactHeader = null;
    protected ArrayList<ViaHeader> viaHeaders = null;
    protected static final int MAX_FORWARDS = 70;
    protected MaxForwardsHeader maxForwardsHeader = null;
    protected long registrationTransaction = -1L;
    protected ArrayList<CommunicationsListener> listeners = new ArrayList();
    protected boolean isStarted = false;
    private RegisterProcessing registerProcessing = null;
    public SipSecurityManager sipSecurityManager = null;

    public SipManager(InetAddress localAddress) {
        this.localAddress = localAddress;
        this.registerProcessing = new RegisterProcessing(this);
        this.sipSecurityManager = new SipSecurityManager();
    }

    public void start() throws CommunicationsException {
        this.initProperties();
        SIPConfig.setSystemProperties();
        this.sipFactory = SipFactory.getInstance();
        this.sipFactory.setPathName(this.sipStackPath);
        try {
            this.addressFactory = this.sipFactory.createAddressFactory();
            this.headerFactory = this.sipFactory.createHeaderFactory();
            this.messageFactory = this.sipFactory.createMessageFactory();
        }
        catch (PeerUnavailableException ex) {
            Log.error("start", (Exception)((Object)ex));
            throw new CommunicationsException("Could not create factories!", ex);
        }
        try {
            this.sipStack = this.sipFactory.createSipStack(System.getProperties());
            ((SipCommRouter)this.sipStack.getRouter()).setOutboundProxy(SIPConfig.getOutboundProxy());
        }
        catch (PeerUnavailableException ex) {
            Log.error("start", (Exception)((Object)ex));
            throw new CommunicationsException("Cannot connect!\nCannot reach proxy.\nCheck your connection.(Syntax:<proxy_address:port/transport>)", ex);
        }
        try {
            boolean successfullyBound = false;
            while (!successfullyBound) {
                try {
                    this.publicIpAddress = new InetSocketAddress(this.localAddress, this.localPort);
                    this.listeningPoint = this.sipStack.createListeningPoint(this.localPort, this.transport);
                }
                catch (InvalidArgumentException ex) {
                    this.localPort = (int)(63976.0 * Math.random()) + 1024;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                successfullyBound = true;
            }
        }
        catch (TransportNotSupportedException ex) {
            throw new CommunicationsException("Transport " + this.transport + " is not suppported by the stack!\n Try specifying another transport in Mais property files.\n", ex);
        }
        try {
            this.sipProvider = this.sipStack.createSipProvider(this.listeningPoint);
        }
        catch (ObjectInUseException ex) {
            Log.error("start", (Exception)((Object)ex));
            throw new CommunicationsException("Could not create factories!\n", ex);
        }
        try {
            this.sipProvider.addSipListener((SipListener)this);
        }
        catch (TooManyListenersException exc) {
            throw new CommunicationsException("Could not register SipManager as a sip listener!", exc);
        }
        this.sipSecurityManager.setHeaderFactory(this.headerFactory);
        this.sipSecurityManager.setTransactionCreator(this.sipProvider);
        this.sipSecurityManager.setSipManCallback(this);
        this.contactHeader = null;
        this.fromHeader = null;
        this.viaHeaders = null;
        this.maxForwardsHeader = null;
        this.isStarted = true;
    }

    public synchronized void stop() throws CommunicationsException {
        int tries;
        if (this.sipStack == null) {
            return;
        }
        for (tries = 0; tries < 10; ++tries) {
            try {
                this.sipStack.deleteSipProvider(this.sipProvider);
                break;
            }
            catch (ObjectInUseException ex) {
                SipManager.sleep(500L);
                continue;
            }
        }
        if (this.sipStack == null) {
            return;
        }
        if (tries >= 10) {
            throw new CommunicationsException("Failed to delete the sipProvider!");
        }
        if (this.sipStack == null) {
            return;
        }
        for (tries = 0; tries < 10; ++tries) {
            try {
                this.sipStack.deleteListeningPoint(this.listeningPoint);
                break;
            }
            catch (ObjectInUseException ex) {
                SipManager.sleep(500L);
                continue;
            }
        }
        if (this.sipStack != null) {
            Iterator it = this.sipStack.getSipProviders();
            while (it.hasNext()) {
                SipProvider element = (SipProvider)it.next();
                try {
                    this.sipStack.deleteSipProvider(element);
                }
                catch (Exception exception) {}
            }
        }
        if (tries >= 10) {
            throw new CommunicationsException("Failed to delete a listeningPoint!");
        }
        this.listeningPoint = null;
        this.addressFactory = null;
        this.messageFactory = null;
        this.headerFactory = null;
        this.sipStack = null;
        this.registrarAddress = null;
        this.viaHeaders = null;
        this.contactHeader = null;
        this.fromHeader = null;
    }

    protected static void sleep(long sleepFor) {
        long startTime = System.currentTimeMillis();
        long haveBeenSleeping = 0L;
        while (haveBeenSleeping < sleepFor) {
            try {
                Thread.sleep(sleepFor - haveBeenSleeping);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            haveBeenSleeping = System.currentTimeMillis() - startTime;
        }
    }

    public void setCurrentlyUsedURI(String uri) {
        this.currentlyUsedURI = uri;
    }

    public void register(String publicAddress) {
        try {
            if (publicAddress == null || publicAddress.trim().length() == 0) {
                Log.debug("PUBLIC NOT FOUND!");
                return;
            }
            if (!publicAddress.trim().toLowerCase().startsWith("sip:")) {
                publicAddress = "sip:" + publicAddress;
            }
            this.currentlyUsedURI = publicAddress;
            this.registerProcessing.register(this.registrarAddress, this.registrarPort, this.registrarTransport, this.registrationsExpiration);
        }
        catch (Exception e) {
            Log.error("register", e);
        }
    }

    public void startRegisterProcess(String userName, String authUserName, String password) throws CommunicationsException {
        try {
            this.checkIfStarted();
            String realm = SIPConfig.getAuthenticationRealm();
            realm = realm == null ? "" : realm;
            SIPConfig.setUserName(userName);
            SIPConfig.setAuthUserName(authUserName);
            UserCredentials initialCredentials = new UserCredentials();
            initialCredentials.setUserName(userName);
            initialCredentials.setAuthUserName(authUserName);
            initialCredentials.setPassword(password.toCharArray());
            this.register(initialCredentials.getUserName() + "@" + realm);
            initialCredentials.setUserName(((SipURI)this.getFromHeader().getAddress().getURI()).getUser());
            this.cacheCredentials(realm, initialCredentials);
        }
        catch (Exception ee) {
            Log.error("startRegisterProcess", ee);
        }
    }

    public void unregister() throws CommunicationsException {
        try {
            this.checkIfStarted();
            this.registerProcessing.unregister();
            this.fireUnregistered(this.registrarAddress == null ? "" : this.registrarAddress);
        }
        catch (Exception e) {
            Log.error("unregister", e);
        }
    }

    private void registrationFailed(RegistrationEvent.Type type) {
        try {
            this.fireRegistrationFailed(this.registrarAddress == null ? "" : this.registrarAddress, type);
        }
        catch (Exception e) {
            Log.error("unregister", e);
        }
    }

    public boolean isRegistered() {
        return this.registerProcessing != null && this.registerProcessing.isRegistered();
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    void sendNotImplemented(ServerTransaction serverTransaction, Request request) {
        Response notImplemented;
        try {
            notImplemented = this.messageFactory.createResponse(501, request);
            this.attachToTag(notImplemented, serverTransaction.getDialog());
        }
        catch (ParseException ex) {
            this.fireCommunicationsError(new CommunicationsException("Failed to create a NOT_IMPLEMENTED response to a " + request.getMethod() + " request!", ex));
            return;
        }
        try {
            serverTransaction.sendResponse(notImplemented);
        }
        catch (InvalidArgumentException | SipException ex) {
            this.fireCommunicationsError(new CommunicationsException("Failed to create a NOT_IMPLEMENTED response to a " + request.getMethod() + " request!", ex));
        }
    }

    public void fireCommunicationsError(Throwable throwable) {
    }

    public FromHeader getFromHeader() throws CommunicationsException {
        return this.getFromHeader(false);
    }

    public FromHeader getFromHeader(boolean isNew) throws CommunicationsException {
        if (this.fromHeader != null && !isNew) {
            return this.fromHeader;
        }
        try {
            SipURI fromURI = (SipURI)this.addressFactory.createURI(this.currentlyUsedURI);
            fromURI.setTransportParam(this.listeningPoint.getTransport());
            fromURI.setPort(this.listeningPoint.getPort());
            Address fromAddress = this.addressFactory.createAddress((URI)fromURI);
            if (this.displayName != null && this.displayName.trim().length() > 0) {
                fromAddress.setDisplayName(this.displayName);
            } else {
                fromAddress.setDisplayName(UserCredentials.getUserDisplay());
            }
            this.fromHeader = this.headerFactory.createFromHeader(fromAddress, Integer.toString(this.hashCode()));
        }
        catch (ParseException ex) {
            throw new CommunicationsException("A ParseException occurred while creating From Header!", ex);
        }
        return this.fromHeader;
    }

    public ContactHeader getContactHeader() throws CommunicationsException {
        return this.getContactHeader(true);
    }

    ContactHeader getRegistrationContactHeader() throws CommunicationsException {
        return this.getContactHeader(true);
    }

    public ContactHeader getContactHeader(boolean useLocalHostAddress) throws CommunicationsException {
        if (this.contactHeader != null) {
            return this.contactHeader;
        }
        try {
            SipURI contactURI = useLocalHostAddress ? this.addressFactory.createSipURI(null, UserCredentials.getUserDisplay() + "@" + this.publicIpAddress.getAddress().getHostAddress()) : (SipURI)this.addressFactory.createURI(this.currentlyUsedURI);
            contactURI.setPort(this.publicIpAddress.getPort());
            Address contactAddress = this.addressFactory.createAddress((URI)contactURI);
            if (this.displayName != null && this.displayName.trim().length() > 0) {
                contactAddress.setDisplayName(this.displayName);
            }
            this.contactHeader = this.headerFactory.createContactHeader(contactAddress);
        }
        catch (ParseException ex) {
            throw new CommunicationsException("A ParseException occurred while creating From Header!", ex);
        }
        return this.contactHeader;
    }

    public ArrayList<ViaHeader> getLocalViaHeaders() throws CommunicationsException {
        if (this.viaHeaders != null) {
            return this.viaHeaders;
        }
        ListeningPoint lp = this.sipProvider.getListeningPoint();
        this.viaHeaders = new ArrayList();
        try {
            ViaHeader viaHeader = this.headerFactory.createViaHeader(SIPConfig.getIPAddress(), lp.getPort(), lp.getTransport(), null);
            viaHeader.setParameter("rport", null);
            this.viaHeaders.add(viaHeader);
            return this.viaHeaders;
        }
        catch (ParseException ex) {
            throw new CommunicationsException("A ParseException occurred while creating Via Headers!");
        }
        catch (InvalidArgumentException ex) {
            throw new CommunicationsException("Unable to create a via header for port " + lp.getPort(), ex);
        }
    }

    public MaxForwardsHeader getMaxForwardsHeader() throws CommunicationsException {
        if (this.maxForwardsHeader != null) {
            return this.maxForwardsHeader;
        }
        try {
            this.maxForwardsHeader = this.headerFactory.createMaxForwardsHeader(70);
            return this.maxForwardsHeader;
        }
        catch (InvalidArgumentException ex) {
            throw new CommunicationsException("A problem occurred while creating MaxForwardsHeader", ex);
        }
    }

    public String getLocalUser() {
        try {
            return ((SipURI)this.getFromHeader().getAddress().getURI()).getUser();
        }
        catch (CommunicationsException ex) {
            return "";
        }
    }

    public void attachToTag(Response response, Dialog containingDialog) {
        ToHeader to = (ToHeader)response.getHeader("To");
        if (to == null) {
            this.fireCommunicationsError(new CommunicationsException("No TO header found in, attaching a to tag is therefore impossible"));
        }
        try {
            if (to.getTag() == null || to.getTag().trim().length() == 0) {
                int toTag = containingDialog != null ? containingDialog.hashCode() : (int)System.currentTimeMillis();
                to.setTag(Integer.toString(toTag));
            }
        }
        catch (ParseException ex) {
            this.fireCommunicationsError(new CommunicationsException("Failed to attach a TO tag to an outgoing response"));
        }
    }

    protected void initProperties() {
        try {
            this.stackAddress = this.getLocalHostAddress();
            SIPConfig.setIPAddress(this.stackAddress);
            SIPConfig.setSystemProperties();
            if (this.stackAddress.indexOf(58) != this.stackAddress.lastIndexOf(58) && this.stackAddress.charAt(0) != '[') {
                this.stackAddress = '[' + this.stackAddress.trim() + ']';
            }
            this.stackName = SIPConfig.getStackName();
            if (this.stackName == null) {
                this.stackName = "SIPark@" + Integer.toString(this.hashCode());
            }
            this.currentlyUsedURI = SIPConfig.getPublicAddress();
            if (this.currentlyUsedURI == null) {
                this.currentlyUsedURI = SIPConfig.getUserName() + "@" + this.stackAddress;
            }
            if (!this.currentlyUsedURI.trim().toLowerCase().startsWith("sip:")) {
                this.currentlyUsedURI = "sip:" + this.currentlyUsedURI.trim();
            }
            this.registrarAddress = SIPConfig.getRegistrarAddress();
            try {
                this.registrarPort = SIPConfig.getRegistrarPort();
            }
            catch (NumberFormatException ex) {
                this.registrarPort = 5060;
            }
            this.registrarTransport = SIPConfig.getRegistrarTransport();
            if (this.registrarTransport == null) {
                this.registrarTransport = DEFAULT_TRANSPORT;
            }
            try {
                this.registrationsExpiration = SIPConfig.getRegistrationExpiration();
            }
            catch (NumberFormatException ex) {
                this.registrationsExpiration = 3600;
            }
            this.sipStackPath = SIPConfig.getStackPath();
            if (this.sipStackPath == null) {
                this.sipStackPath = "gov.nist";
            }
            this.transport = SIPConfig.getTransport();
            if (this.transport.equals("")) {
                this.transport = DEFAULT_TRANSPORT;
            }
            try {
                this.localPort = SIPConfig.getLocalPort();
            }
            catch (NumberFormatException exc) {
                this.localPort = 5060;
            }
            this.displayName = SIPConfig.getDisplayName();
        }
        catch (Exception e) {
            Log.error(e.getMessage(), e);
        }
    }

    public void cacheCredentials(String realm, UserCredentials credentials) {
        this.sipSecurityManager.cacheCredentials(realm, credentials);
    }

    public void addCommunicationsListener(CommunicationsListener listener) {
        try {
            this.listeners.add(listener);
        }
        catch (Exception e) {
            Log.error("addCommunicationsListener", e);
        }
    }

    void fireRegistered(String address) {
        RegistrationEvent evt = new RegistrationEvent(address);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).registered(evt);
        }
    }

    void fireRegistering(String address) {
        RegistrationEvent evt = new RegistrationEvent(address);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).registering(evt);
        }
    }

    public void fireUnregistered(String address) {
        RegistrationEvent evt = new RegistrationEvent(address);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).unregistered(evt);
        }
    }

    void fireRegistrationFailed(String address, RegistrationEvent.Type type) {
        RegistrationEvent evt = new RegistrationEvent(address, type);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).registrationFailed(evt);
        }
    }

    void fireUnregistering(String address) {
        RegistrationEvent evt = new RegistrationEvent(address);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).unregistering(evt);
        }
    }

    public void processRequest(RequestEvent requestEvent) {
    }

    public void processResponse(ResponseEvent responseReceivedEvent) {
        Log.debug("RESPONSE [" + responseReceivedEvent.getResponse().getStatusCode() + "]");
        ClientTransaction clientTransaction = responseReceivedEvent.getClientTransaction();
        if (clientTransaction == null) {
            return;
        }
        Response response = responseReceivedEvent.getResponse();
        String method = ((CSeqHeader)response.getHeader("CSeq")).getMethod();
        if (response.getStatusCode() == 200) {
            if (method.equals("REGISTER")) {
                this.registerProcessing.processOK(clientTransaction, response);
            }
        } else if (response.getStatusCode() == 404) {
            if (method.equals("REGISTER")) {
                try {
                    this.unregister();
                    this.registrationFailed(RegistrationEvent.Type.NotFound);
                }
                catch (CommunicationsException e) {
                    Log.error("NOT FOUND", e);
                }
                Log.debug("REGISTER NOT FOUND");
            }
        } else if (response.getStatusCode() == 501) {
            if (method.equals("REGISTER")) {
                this.registerProcessing.processNotImplemented(clientTransaction, response);
            }
        } else if (response.getStatusCode() == 401 || response.getStatusCode() == 407) {
            if (method.equals("REGISTER")) {
                CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
                if (cseq.getSequenceNumber() < 2) {
                    this.registerProcessing.processAuthenticationChallenge(clientTransaction, response);
                } else {
                    this.registrationFailed(RegistrationEvent.Type.WrongPass);
                }
            }
        } else if (response.getStatusCode() == 403) {
            this.registrationFailed(RegistrationEvent.Type.Forbidden);
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
    }

    String getLocalHostAddress() {
        return this.localAddress.getHostAddress();
    }

    protected void checkIfStarted() throws CommunicationsException {
        if (!this.isStarted) {
            throw new CommunicationsException("The underlying SIP Stack had not beenproperly initialised! Impossible to continue");
        }
    }

    public static void main(String[] args) {
        SIPConfig.setRegistrarAddress("apollo");
        SIPConfig.setAuthenticationRealm("apollo");
        SIPConfig.setDefaultDomain("apollo");
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        SipManager sipManager = new SipManager(address);
        try {
            sipManager.start();
        }
        catch (CommunicationsException e) {
            e.printStackTrace();
        }
        try {
            sipManager.startRegisterProcess("7512", "7512", "7512");
        }
        catch (CommunicationsException e) {
            e.printStackTrace();
        }
        try {
            sipManager.unregister();
        }
        catch (CommunicationsException e) {
            e.printStackTrace();
        }
    }
}

