/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sip.tester.stack;

import java.util.LinkedList;
import java.util.ListIterator;
import javax.sip.SipStack;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.RouteHeader;
import javax.sip.message.Request;
import org.jivesoftware.openfire.sip.tester.Log;
import org.jivesoftware.openfire.sip.tester.stack.SIPConfig;
import org.jivesoftware.openfire.sip.tester.stack.SipCommHop;

public class SipCommRouter
implements Router {
    protected SipStack myStack;
    protected SipCommHop outboundProxy = null;
    protected Router stackRouter = null;

    public SipCommRouter(SipStack sipStack, String outboundProxy) {
        outboundProxy = SIPConfig.getOutboundProxy();
        this.myStack = sipStack;
        if (outboundProxy != null && outboundProxy.length() > 0) {
            this.outboundProxy = new SipCommHop(outboundProxy);
        }
    }

    public ListIterator<Hop> getNextHops(Request sipRequest) {
        ListIterator routes;
        URI requestURI = sipRequest.getRequestURI();
        if (requestURI == null) {
            throw new IllegalArgumentException("Bad message: Null requestURI");
        }
        LinkedList<SipCommHop> hops = new LinkedList<SipCommHop>();
        if (this.outboundProxy != null) {
            hops.add(this.outboundProxy);
        }
        if ((routes = sipRequest.getHeaders("Route")) != null && routes.hasNext()) {
            while (routes.hasNext()) {
                RouteHeader route = (RouteHeader)routes.next();
                SipURI uri = (SipURI)route.getAddress().getURI();
                int port = uri.getPort();
                port = port == -1 ? 5060 : port;
                String host = uri.getHost();
                Log.debug("getNextHops", host);
                String transport = uri.getTransportParam();
                if (transport == null) {
                    transport = "udp";
                }
                SipCommHop hop = new SipCommHop(host + ':' + port + '/' + transport);
                hops.add(hop);
            }
        } else if (requestURI instanceof SipURI && ((SipURI)requestURI).getMAddrParam() != null) {
            SipURI sipURI = (SipURI)requestURI;
            String maddr = sipURI.getMAddrParam();
            String transport = sipURI.getTransportParam();
            if (transport == null) {
                transport = "udp";
            }
            int port = 5060;
            SipCommHop hop = new SipCommHop(maddr, port, transport);
            hops.add(hop);
        } else if (requestURI instanceof SipURI) {
            SipURI sipURI = (SipURI)requestURI;
            int port = sipURI.getPort();
            if (port == -1) {
                port = 5060;
            }
            String host = sipURI.getHost();
            String transport = sipURI.getTransportParam();
            if (transport == null) {
                transport = "UDP";
            }
            SipCommHop hop = new SipCommHop(host + ":" + port + "/" + transport);
            hops.add(hop);
        } else {
            throw new IllegalArgumentException("Malformed requestURI");
        }
        return hops.size() == 0 ? null : hops.listIterator();
    }

    public Hop getOutboundProxy() {
        return this.outboundProxy;
    }

    protected void setOutboundProxy(String proxy) {
        if (SIPConfig.getOutboundProxy() != null && SIPConfig.getOutboundProxy().length() > 0) {
            this.outboundProxy = new SipCommHop(proxy);
        }
    }

    public Hop getNextHop(Request request) {
        throw new UnsupportedOperationException();
    }
}

