/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sip.tester.stack;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.UserAgentHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.jivesoftware.openfire.sip.tester.Log;
import org.jivesoftware.openfire.sip.tester.comm.CommunicationsException;
import org.jivesoftware.openfire.sip.tester.security.SipSecurityException;
import org.jivesoftware.openfire.sip.tester.stack.SIPConfig;
import org.jivesoftware.openfire.sip.tester.stack.SipManager;

class RegisterProcessing {
    private SipManager sipManCallback = null;
    private Request registerRequest = null;
    private boolean isRegistered = false;
    private boolean isUnregistering = false;
    private Timer reRegisterTimer = null;
    private Timer keepAliveTimer = null;

    RegisterProcessing(SipManager sipManCallback) {
        this.sipManCallback = sipManCallback;
    }

    void setSipManagerCallBack(SipManager sipManCallback) {
        this.sipManCallback = sipManCallback;
    }

    void processOK(ClientTransaction clientTransatcion, Response response) {
        this.isRegistered = true;
        FromHeader fromHeader = (FromHeader)response.getHeader("From");
        Address address = fromHeader.getAddress();
        int expires = 0;
        if (!this.isUnregistering) {
            ContactHeader contactHeader = (ContactHeader)response.getHeader("Contact");
            if (contactHeader != null) {
                expires = contactHeader.getExpires();
            } else {
                ExpiresHeader expiresHeader = response.getExpires();
                if (expiresHeader != null) {
                    expires = expiresHeader.getExpires();
                }
            }
        }
        if (expires == 0) {
            this.isUnregistering = false;
            this.sipManCallback.fireUnregistered(address.toString());
        } else {
            if (this.reRegisterTimer != null) {
                this.reRegisterTimer.cancel();
            }
            if (this.keepAliveTimer != null) {
                this.keepAliveTimer.cancel();
            }
            this.reRegisterTimer = new Timer();
            this.keepAliveTimer = new Timer();
            SipURI uri = (SipURI)address.getURI();
            this.scheduleReRegistration(uri.getHost(), uri.getPort(), uri.getTransportParam(), expires);
            this.sipManCallback.fireRegistered(address.toString());
        }
    }

    void processTimeout(Transaction transatcion, Request request) {
        this.isRegistered = true;
        FromHeader fromHeader = (FromHeader)request.getHeader("From");
        Address address = fromHeader.getAddress();
        this.sipManCallback.fireUnregistered("Request timeouted for: " + address.toString());
    }

    void processNotImplemented(ClientTransaction transatcion, Response response) {
        this.isRegistered = true;
        FromHeader fromHeader = (FromHeader)response.getHeader("From");
        Address address = fromHeader.getAddress();
        this.sipManCallback.fireUnregistered("Server returned NOT_IMPLEMENTED. " + address.toString());
    }

    void processAuthenticationChallenge(ClientTransaction clientTransaction, Response response) {
        try {
            ClientTransaction retryTran = this.sipManCallback.sipSecurityManager.handleChallenge(response, clientTransaction);
            retryTran.sendRequest();
        }
        catch (SipSecurityException exc) {
            this.sipManCallback.fireUnregistered(((FromHeader)clientTransaction.getRequest().getHeader("From")).getAddress().toString());
            this.sipManCallback.fireCommunicationsError(new CommunicationsException("Authorization failed!", exc));
        }
        catch (Exception exc) {
            this.sipManCallback.fireUnregistered(((FromHeader)clientTransaction.getRequest().getHeader("From")).getAddress().toString());
            this.sipManCallback.fireCommunicationsError(new CommunicationsException("Failed to resend a request after a security challenge!", exc));
        }
    }

    synchronized void register(String registrarAddress, int registrarPort, String registrarTransport, int expires) throws CommunicationsException {
        try {
            this.isUnregistering = false;
            FromHeader fromHeader = this.sipManCallback.getFromHeader(true);
            Address fromAddress = fromHeader.getAddress();
            this.sipManCallback.fireRegistering(fromAddress.toString());
            SipURI requestURI = null;
            try {
                requestURI = this.sipManCallback.addressFactory.createSipURI(null, registrarAddress);
            }
            catch (ParseException ex) {
                throw new CommunicationsException("Bad registrar address:" + registrarAddress, ex);
            }
            catch (NullPointerException ex) {
                this.sipManCallback.fireUnregistered(fromAddress.getURI().toString() + " (registrar not specified)");
                return;
            }
            requestURI.setPort(registrarPort);
            try {
                requestURI.setTransportParam(registrarTransport);
            }
            catch (ParseException ex) {
                throw new CommunicationsException(registrarTransport + " is not a valid transport!", ex);
            }
            CallIdHeader callIdHeader = this.sipManCallback.sipProvider.getNewCallId();
            CSeqHeader cSeqHeader = null;
            try {
                cSeqHeader = this.sipManCallback.headerFactory.createCSeqHeader(1, "REGISTER");
            }
            catch (ParseException ex) {
                Log.error("register", ex);
            }
            catch (InvalidArgumentException ex) {
                Log.error("register", (Exception)((Object)ex));
            }
            ToHeader toHeader = null;
            try {
                toHeader = this.sipManCallback.headerFactory.createToHeader(fromAddress, null);
            }
            catch (ParseException ex) {
                throw new CommunicationsException("Could not create a To header for address:" + fromHeader.getAddress(), ex);
            }
            UserAgentHeader uaHeader = null;
            ArrayList<String> userAgentList = new ArrayList<String>();
            userAgentList.add(SIPConfig.getStackName());
            try {
                uaHeader = this.sipManCallback.headerFactory.createUserAgentHeader(userAgentList);
            }
            catch (ParseException ex) {
                throw new CommunicationsException("Could not create a To header for address:" + fromHeader.getAddress(), ex);
            }
            ArrayList<ViaHeader> viaHeaders = this.sipManCallback.getLocalViaHeaders();
            MaxForwardsHeader maxForwardsHeader = this.sipManCallback.getMaxForwardsHeader();
            Request request = null;
            try {
                request = this.sipManCallback.messageFactory.createRequest((URI)requestURI, "REGISTER", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwardsHeader);
                request.setHeader((Header)uaHeader);
            }
            catch (ParseException ex) {
                throw new CommunicationsException("Could not create the register request!", ex);
            }
            ExpiresHeader expHeader = null;
            for (int retry = 0; retry < 2; ++retry) {
                try {
                    expHeader = this.sipManCallback.headerFactory.createExpiresHeader(expires);
                    continue;
                }
                catch (InvalidArgumentException ex) {
                    if (retry == 0) {
                        expires = 3600;
                        continue;
                    }
                    throw new CommunicationsException("Invalid registrations expiration parameter - " + expires, ex);
                }
            }
            request.addHeader(expHeader);
            ContactHeader contactHeader = this.sipManCallback.getRegistrationContactHeader();
            request.addHeader((Header)contactHeader);
            ClientTransaction regTrans = null;
            try {
                regTrans = this.sipManCallback.sipProvider.getNewClientTransaction(request);
            }
            catch (TransactionUnavailableException ex) {
                throw new CommunicationsException("Could not create a register transaction!\nCheck that the Registrar address is correct!");
            }
            try {
                regTrans.sendRequest();
            }
            catch (Exception ex) {
                throw new CommunicationsException("Could not send out the register request!", ex);
            }
            this.registerRequest = request;
        }
        catch (Exception e) {
            Log.error("register", e);
        }
    }

    synchronized void unregister() throws CommunicationsException {
        try {
            Log.debug("UNREGISTER");
            this.cancelPendingRegistrations();
            this.isRegistered = false;
            this.isUnregistering = true;
            Request registerRequest = this.getRegisterRequest();
            if (this.registerRequest == null) {
                throw new CommunicationsException("Couldn't find the initial register request");
            }
            Request unregisterRequest = (Request)registerRequest.clone();
            try {
                unregisterRequest.getExpires().setExpires(0);
                CSeqHeader cSeqHeader = (CSeqHeader)unregisterRequest.getHeader("CSeq");
                cSeqHeader.setSequenceNumber(cSeqHeader.getSequenceNumber() + 1);
            }
            catch (InvalidArgumentException ex) {
                throw new CommunicationsException("Unable to set Expires Header", ex);
            }
            ClientTransaction unregisterTransaction = null;
            try {
                unregisterTransaction = this.sipManCallback.sipProvider.getNewClientTransaction(unregisterRequest);
            }
            catch (TransactionUnavailableException ex) {
                throw new CommunicationsException("Unable to create a unregister transaction", ex);
            }
            try {
                this.sipManCallback.fireUnregistering(this.sipManCallback.currentlyUsedURI);
                unregisterTransaction.sendRequest();
            }
            catch (SipException ex) {
                throw new CommunicationsException("Failed to send unregister request", ex);
            }
        }
        catch (Exception e) {
            Log.error("unregister", e);
        }
    }

    public void cancelSchedules() {
        if (this.reRegisterTimer != null) {
            this.reRegisterTimer.cancel();
        }
        if (this.keepAliveTimer != null) {
            this.keepAliveTimer.cancel();
        }
        this.reRegisterTimer = null;
        this.keepAliveTimer = null;
    }

    boolean isRegistered() {
        return this.isRegistered;
    }

    private Request getRegisterRequest() {
        return this.registerRequest;
    }

    private void cancelPendingRegistrations() {
        try {
            if (this.reRegisterTimer != null) {
                this.reRegisterTimer.cancel();
            }
            if (this.keepAliveTimer != null) {
                this.keepAliveTimer.cancel();
            }
            this.reRegisterTimer = null;
            this.keepAliveTimer = null;
        }
        catch (Exception e) {
            Log.error("cancelPendingRegistrations", e);
        }
    }

    private void scheduleReRegistration(String registrarAddress, int registrarPort, String registrarTransport, int expires) {
        ReRegisterTask reRegisterTask = new ReRegisterTask(registrarAddress, registrarPort, registrarTransport, expires);
        this.reRegisterTimer.schedule((TimerTask)reRegisterTask, expires *= 900);
    }

    private class ReRegisterTask
    extends TimerTask {
        String registrarAddress = null;
        int registrarPort = -1;
        String transport = null;
        int expires = 0;

        public ReRegisterTask(String registrarAddress, int registrarPort, String registrarTransport, int expires) {
            this.registrarAddress = registrarAddress;
            this.registrarPort = registrarPort;
            this.transport = registrarTransport;
            this.expires = expires;
        }

        @Override
        public void run() {
            try {
                if (RegisterProcessing.this.isRegistered()) {
                    RegisterProcessing.this.register(this.registrarAddress, this.registrarPort, this.transport, this.expires);
                }
            }
            catch (CommunicationsException ex) {
                RegisterProcessing.this.sipManCallback.fireCommunicationsError(new CommunicationsException("Failed to reRegister", ex));
            }
        }
    }
}

