/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sip.tester.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestAlgorithm {
    private static final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    static String calculateResponse(String algorithm, String username_value, String realm_value, String passwd, String nonce_value, String nc_value, String cnonce_value, String Method, String digest_uri_value, String entity_body, String qop_value) {
        if (username_value == null || realm_value == null || passwd == null || Method == null || digest_uri_value == null || nonce_value == null) {
            throw new NullPointerException("Null parameter to MessageDigestAlgorithm.calculateResponse()");
        }
        String A1 = null;
        if (algorithm == null || algorithm.trim().length() == 0 || algorithm.trim().equalsIgnoreCase("MD5")) {
            A1 = username_value + ":" + realm_value + ":" + passwd;
        } else {
            if (cnonce_value == null || cnonce_value.length() == 0) {
                throw new NullPointerException("cnonce_value may not be absent for MD5-Sess algorithm.");
            }
            A1 = MessageDigestAlgorithm.H(username_value + ":" + realm_value + ":" + passwd) + ":" + nonce_value + ":" + cnonce_value;
        }
        String A2 = null;
        if (qop_value == null || qop_value.trim().length() == 0 || qop_value.trim().equalsIgnoreCase("auth")) {
            A2 = Method + ":" + digest_uri_value;
        } else {
            if (entity_body == null) {
                entity_body = "";
            }
            A2 = Method + ":" + digest_uri_value + ":" + MessageDigestAlgorithm.H(entity_body);
        }
        String request_digest = null;
        request_digest = cnonce_value != null && qop_value != null && (qop_value.equals("auth") || qop_value.equals("auth-int")) ? MessageDigestAlgorithm.KD(MessageDigestAlgorithm.H(A1), nonce_value + ":" + nc_value + ":" + cnonce_value + ":" + qop_value + ":" + MessageDigestAlgorithm.H(A2)) : MessageDigestAlgorithm.KD(MessageDigestAlgorithm.H(A1), nonce_value + ":" + MessageDigestAlgorithm.H(A2));
        return request_digest;
    }

    private static String H(String data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            return MessageDigestAlgorithm.toHexString(digest.digest(data.getBytes()));
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    private static String KD(String secret, String data) {
        return MessageDigestAlgorithm.H(secret + ":" + data);
    }

    private static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
        }
        return new String(c);
    }
}

