/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.sip.calllog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.sip.calllog.CallFilter;
import org.jivesoftware.openfire.sip.calllog.CallLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallLogDAO {
    private static final Logger Log = LoggerFactory.getLogger(CallLogDAO.class);
    static final CallFilter emptyFilter = new CallFilter("", new ArrayList<String>());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<CallLog> getCalls(CallFilter filter, int startIndex, int numResults) {
        String sql = "SELECT * FROM ofSipPhoneLog";
        sql = filter != null && !filter.getSQL().equals("") ? sql + " WHERE " + filter.getSQL() : sql;
        sql = sql + " ORDER BY datetime DESC";
        ArrayList<CallLog> calls = new ArrayList<CallLog>(numResults);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = DbConnectionManager.createScrollablePreparedStatement((Connection)con, (String)sql);
            int i = 1;
            for (String value : filter.getValues()) {
                pstmt.setString(i++, value);
            }
            ResultSet rs = pstmt.executeQuery();
            DbConnectionManager.setFetchSize((ResultSet)rs, (int)(startIndex + numResults));
            DbConnectionManager.scrollResultSet((ResultSet)rs, (int)startIndex);
            for (int count = 0; rs.next() && count < numResults; ++count) {
                calls.add(CallLogDAO.read(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        return calls;
    }

    private static CallLog read(ResultSet rs) {
        CallLog callLog = null;
        try {
            String username = rs.getString("username");
            String numA = rs.getString("addressFrom");
            String numB = rs.getString("addressTo");
            long dateTime = rs.getLong("datetime");
            int duration = rs.getInt("duration");
            String callType = rs.getString("calltype");
            if ("loss".equals(callType)) {
                callType = "missed";
            }
            CallLog.Type type = CallLog.Type.valueOf(callType);
            callLog = new CallLog(username);
            callLog.setNumA(numA);
            callLog.setNumB(numB);
            callLog.setDateTime(dateTime);
            callLog.setDuration(duration);
            callLog.setType(type);
        }
        catch (SQLException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        return callLog;
    }

    public static void insert(CallLog callLog) throws SQLException {
        String sql = "INSERT INTO ofSipPhoneLog (username, addressFrom, addressTo, datetime, duration, calltype)  values  (?, ?, ?, ?, ?, ?)";
        Connection con = null;
        PreparedStatement psmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            psmt = con.prepareStatement(sql);
            psmt.setString(1, callLog.getUsername());
            psmt.setString(2, callLog.getNumA());
            psmt.setString(3, callLog.getNumB());
            psmt.setLong(4, callLog.getDateTime());
            psmt.setInt(5, callLog.getDuration());
            psmt.setString(6, callLog.getType().name());
            psmt.executeUpdate();
        }
        catch (SQLException e) {
            Log.error(e.getMessage(), (Throwable)e);
            throw new SQLException(e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)psmt, (Connection)con);
        }
    }

    public static Collection<CallLog> getCalls(int startIndex, int numResults) {
        return CallLogDAO.getCalls(emptyFilter, startIndex, numResults);
    }

    public static int getLogCount() {
        return CallLogDAO.getLogCount(emptyFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLogCount(CallFilter filter) {
        int count = 0;
        String sql = "SELECT count(*) FROM ofSipPhoneLog";
        sql = filter != null && !filter.getSQL().equals("") ? sql + " WHERE " + filter.getSQL() : sql;
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            int i = 1;
            for (String value : filter.getValues()) {
                pstmt.setString(i++, value);
            }
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        return count;
    }

    public static CallFilter createSQLFilter(String username, String numa, String numb, String callType, Date fromDate, Date uptoDate) {
        ArrayList<String> conditions = new ArrayList<String>(10);
        ArrayList<String> values = new ArrayList<String>(10);
        if (username != null && !username.trim().equals("")) {
            conditions.add(" username = ? ");
            values.add(username.trim());
        }
        if (numa != null && !numa.trim().equals("")) {
            conditions.add(" addressFrom = ? ");
            values.add(numa.trim());
        }
        if (numb != null && !numb.trim().equals("")) {
            conditions.add(" addressTo = ? ");
            values.add(numb.trim());
        }
        if (fromDate != null) {
            conditions.add(" datetime >= ? ");
            values.add(String.valueOf(fromDate.getTime()));
        }
        if (uptoDate != null) {
            conditions.add(" datetime <= ? ");
            values.add(String.valueOf(uptoDate.getTime()));
        }
        if (callType != null && !callType.trim().equals("") && !callType.trim().equals("all")) {
            conditions.add(" calltype = ? ");
            values.add(callType.trim());
        }
        StringBuilder str = new StringBuilder();
        for (String aux : conditions) {
            if (str.length() > 0) {
                str.append("AND");
            }
            str.append(aux);
        }
        return new CallFilter(str.toString(), values);
    }
}

