/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;

public class MUCRoomUtils {
    private MUCRoomUtils() {
        throw new AssertionError();
    }

    public static List<String> convertJIDsToStringList(Collection<JID> jids) {
        ArrayList<String> result = new ArrayList<String>();
        for (JID jid : jids) {
            if (jid.getResource() != null) continue;
            result.add(jid.toBareJID());
        }
        return result;
    }

    public static List<String> convertGroupsToStringList(Collection<Group> groups) {
        ArrayList<String> result = new ArrayList<String>();
        for (Group group : groups) {
            result.add(group.getName());
        }
        return result;
    }

    public static List<JID> convertStringsToJIDs(List<String> jids) {
        ArrayList<JID> result = new ArrayList<JID>();
        for (String jidString : jids) {
            result.add(new JID(jidString));
        }
        return result;
    }

    public static List<String> convertRolesToStringList(Collection<MUCRole.Role> roles) {
        return roles.stream().map(Enum::toString).collect(Collectors.toList());
    }

    public static List<MUCRole.Role> convertStringsToRoles(Collection<String> roles) {
        return roles.stream().map(MUCRole.Role::valueOf).collect(Collectors.toList());
    }

    public static MUCRole.Affiliation convertPluralStringToAffiliation(String affiliation) {
        return MUCRole.Affiliation.valueOf((String)(affiliation.endsWith("s") ? affiliation.substring(0, affiliation.length() - 1) : affiliation));
    }

    public static void send(MUCRoom room, Packet packet, MUCRole role) throws InvocationTargetException, IllegalAccessException {
        Method legacySend = MUCRoomUtils.legacySendMethod();
        if (legacySend != null) {
            legacySend.invoke((Object)room, packet);
        } else {
            room.send(packet, role);
        }
    }

    private static Method legacySendMethod() {
        try {
            return MUCRoom.class.getMethod("send", Packet.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

