/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import gnu.inet.encoding.Stringprep;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.SharedGroupException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.rest.RESTServicePlugin;
import org.jivesoftware.openfire.plugin.rest.controller.UserServiceLegacyController;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

@Path(value="restapi/v1")
@Tag(name="UserService (deprecated)", description="Undocumented UserService endpoint, retained for backwards compatibility.")
public class UserServiceLegacy {
    private static Logger LOG = LoggerFactory.getLogger(UserServiceLegacy.class);
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;
    private RESTServicePlugin plugin;
    private UserServiceLegacyController userServiceController;

    @PostConstruct
    public void init() {
        this.plugin = (RESTServicePlugin)XMPPServer.getInstance().getPluginManager().getPlugin("restapi");
        this.userServiceController = UserServiceLegacyController.getInstance();
    }

    @POST
    @Path(value="/userservice")
    public void userSerivcePostRequest() throws IOException {
        this.userSerivceRequest();
    }

    @GET
    @Path(value="/userservice")
    public Response userSerivceRequest() throws IOException {
        PrintWriter out = this.response.getWriter();
        if (!this.plugin.getAllowedIPs().isEmpty()) {
            String ipAddress = this.request.getHeader("x-forwarded-for");
            if (ipAddress == null && (ipAddress = this.request.getHeader("X_FORWARDED_FOR")) == null && (ipAddress = this.request.getHeader("X-Forward-For")) == null) {
                ipAddress = this.request.getRemoteAddr();
            }
            if (!this.plugin.getAllowedIPs().contains(ipAddress)) {
                LOG.warn("User service rejected service to IP address: " + ipAddress);
                this.replyError("RequestNotAuthorised", this.response, out);
                return Response.status((int)200).build();
            }
        }
        String username = this.request.getParameter("username");
        String password = this.request.getParameter("password");
        String name = this.request.getParameter("name");
        String email = this.request.getParameter("email");
        String type = this.request.getParameter("type");
        String secret = this.request.getParameter("secret");
        String groupNames = this.request.getParameter("groups");
        String item_jid = this.request.getParameter("item_jid");
        String sub = this.request.getParameter("subscription");
        if (!this.plugin.isEnabled()) {
            LOG.warn("User service plugin is disabled: " + this.request.getQueryString());
            this.replyError("UserServiceDisabled", this.response, out);
            return Response.status((int)200).build();
        }
        if (secret == null || !secret.equals(this.plugin.getSecret())) {
            LOG.warn("An unauthorised user service request was received: " + this.request.getQueryString());
            this.replyError("RequestNotAuthorised", this.response, out);
            return Response.status((int)200).build();
        }
        if (username == null && !"grouplist".equals(type)) {
            this.replyError("IllegalArgumentException", this.response, out);
            return Response.status((int)200).build();
        }
        if (!(!type.equals("add_roster") && !type.equals("update_roster") && !type.equals("delete_roster") || item_jid != null && (sub == null || sub.equals("-1") || sub.equals("0") || sub.equals("1") || sub.equals("2") || sub.equals("3")))) {
            this.replyError("IllegalArgumentException", this.response, out);
            return Response.status((int)200).build();
        }
        try {
            if ("grouplist".equals(type)) {
                String message = "";
                for (String groupname : this.userServiceController.getAllGroups()) {
                    message = message + "<groupname>" + groupname + "</groupname>";
                }
                this.replyMessage(message, this.response, out);
            } else {
                username = username.trim().toLowerCase();
                username = JID.escapeNode((String)username);
                username = Stringprep.nodeprep((String)username);
                if ("add".equals(type)) {
                    this.userServiceController.createUser(username, password, name, email, groupNames);
                    this.replyMessage("ok", this.response, out);
                } else if ("delete".equals(type)) {
                    this.userServiceController.deleteUser(username);
                    this.replyMessage("ok", this.response, out);
                } else if ("enable".equals(type)) {
                    this.userServiceController.enableUser(username);
                    this.replyMessage("ok", this.response, out);
                } else if ("disable".equals(type)) {
                    this.userServiceController.disableUser(username);
                    this.replyMessage("ok", this.response, out);
                } else if ("update".equals(type)) {
                    this.userServiceController.updateUser(username, password, name, email, groupNames);
                    this.replyMessage("ok", this.response, out);
                } else if ("add_roster".equals(type)) {
                    this.userServiceController.addRosterItem(username, item_jid, name, sub, groupNames);
                    this.replyMessage("ok", this.response, out);
                } else if ("update_roster".equals(type)) {
                    this.userServiceController.updateRosterItem(username, item_jid, name, sub, groupNames);
                    this.replyMessage("ok", this.response, out);
                } else if ("delete_roster".equals(type)) {
                    this.userServiceController.deleteRosterItem(username, item_jid);
                    this.replyMessage("ok", this.response, out);
                } else if ("usergrouplist".equals(type)) {
                    String message = "";
                    for (String groupname : this.userServiceController.getUserGroups(username)) {
                        message = message + "<groupname>" + groupname + "</groupname>";
                    }
                    this.replyMessage(message, this.response, out);
                } else {
                    LOG.warn("The userService servlet received an invalid request of type: " + type);
                }
            }
        }
        catch (UserAlreadyExistsException e) {
            this.replyError("UserAlreadyExistsException", this.response, out);
        }
        catch (UserNotFoundException e) {
            this.replyError("UserNotFoundException", this.response, out);
        }
        catch (IllegalArgumentException e) {
            this.replyError("IllegalArgumentException", this.response, out);
        }
        catch (SharedGroupException e) {
            this.replyError("SharedGroupException", this.response, out);
        }
        catch (Exception e) {
            LOG.error("Error: ", (Throwable)e);
            this.replyError(e.toString(), this.response, out);
        }
        return Response.status((int)200).build();
    }

    private void replyMessage(String message, HttpServletResponse response, PrintWriter out) {
        response.setContentType("text/xml");
        out.println("<result>" + message + "</result>");
        out.flush();
    }

    private void replyError(String error, HttpServletResponse response, PrintWriter out) {
        response.setContentType("text/xml");
        out.println("<error>" + error + "</error>");
        out.flush();
    }
}

