/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.PostConstruct;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.controller.UserServiceController;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;

@Path(value="restapi/v1/lockouts")
@Tag(name="Users", description="Managing Openfire users.")
public class UserLockoutService {
    private UserServiceController plugin;

    @PostConstruct
    public void init() {
        this.plugin = UserServiceController.getInstance();
    }

    @POST
    @Path(value="/{username}")
    @Operation(summary="Lock user out", description="Lockout / ban the user from the chat server. The user will be kicked if the user is online.", responses={@ApiResponse(responseCode="201", description="The user was locked out."), @ApiResponse(responseCode="404", description="No user of with this username exists.")})
    public Response disableUser(@Parameter(description="The username of the user that is to be locked out.", required=true) @PathParam(value="username") String username) throws ServiceException {
        this.plugin.disableUser(username);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    @Path(value="/{username}")
    @Operation(summary="Unlock user", description="Removes a previously applied lockout / ban of a user.", responses={@ApiResponse(responseCode="200", description="User is unlocked."), @ApiResponse(responseCode="404", description="No user of with this username exists.")})
    public Response enableUser(@Parameter(description="The username of the user for which the lockout is to be undone.", required=true) @PathParam(value="username") String username) throws ServiceException {
        this.plugin.enableUser(username);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

