/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.controller.MUCServiceController;
import org.jivesoftware.openfire.plugin.rest.entity.MUCServiceEntities;
import org.jivesoftware.openfire.plugin.rest.entity.MUCServiceEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ErrorResponse;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;

@Path(value="restapi/v1/chatservices")
@Tag(name="Chat service", description="Managing Multi-User chat services.")
public class MUCServiceService {
    @GET
    @Operation(summary="Get chat services", description="Get a list of all multi-user chat services.", responses={@ApiResponse(responseCode="200", description="All chat services", content={@Content(schema=@Schema(implementation=MUCServiceEntities.class))}), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Produces(value={"application/xml", "application/json"})
    public MUCServiceEntities getMUCServices() {
        return MUCServiceController.getInstance().getChatServices();
    }

    @POST
    @Operation(summary="Create new multi-user chat service", description="Create a new multi-user chat service.", responses={@ApiResponse(responseCode="201", description="Service created."), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Service creation is not permitted.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Service already exists, or another conflict occurred while creating the service.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Consumes(value={"application/xml", "application/json"})
    public Response createMUCService(@RequestBody(description="The MUC service that needs to be created.", required=true) MUCServiceEntity mucServiceEntity) throws ServiceException {
        MUCServiceController.getInstance().createChatService(mucServiceEntity);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }
}

