/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.controller.MUCRoomController;
import org.jivesoftware.openfire.plugin.rest.entity.MUCInvitationEntity;
import org.jivesoftware.openfire.plugin.rest.entity.MUCInvitationsEntity;
import org.jivesoftware.openfire.plugin.rest.entity.MUCRoomEntities;
import org.jivesoftware.openfire.plugin.rest.entity.MUCRoomEntity;
import org.jivesoftware.openfire.plugin.rest.entity.MUCRoomMessageEntities;
import org.jivesoftware.openfire.plugin.rest.entity.OccupantEntities;
import org.jivesoftware.openfire.plugin.rest.entity.ParticipantEntities;
import org.jivesoftware.openfire.plugin.rest.entity.RoomCreationResultEntities;
import org.jivesoftware.openfire.plugin.rest.exceptions.ErrorResponse;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.xmpp.packet.JID;

@Path(value="restapi/v1/chatrooms")
@Tag(name="Chat room", description="Managing Multi-User chat rooms.")
public class MUCRoomService {
    @GET
    @Operation(summary="Get chat rooms", description="Get a list of all multi-user chat rooms of a particular chat room service.", responses={@ApiResponse(responseCode="200", description="All chat rooms", content={@Content(schema=@Schema(implementation=MUCRoomEntities.class))}), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="MUC service does not exist or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Produces(value={"application/xml", "application/json"})
    public MUCRoomEntities getMUCRooms(@Parameter(description="The name of the MUC service for which to return all chat rooms.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @Parameter(description="Room type-based filter: 'all' or 'public'", examples={@ExampleObject(value="public", description="Only return rooms configured with 'List Room in Directory'"), @ExampleObject(value="all", description="Return all rooms")}, required=false) @DefaultValue(value="public") @QueryParam(value="type") String channelType, @Parameter(description="Search/Filter by room name.\nThis act like the wildcard search %String%", example="conference", required=false) @QueryParam(value="search") String roomSearch, @Parameter(description="For all groups defined in owners, admins, members and outcasts, list individual members instead of the group name.", required=false) @DefaultValue(value="false") @QueryParam(value="expandGroups") Boolean expand) throws ServiceException {
        return MUCRoomController.getInstance().getChatRooms(serviceName, channelType, roomSearch, expand);
    }

    @GET
    @Path(value="/{roomName}")
    @Operation(summary="Get chat room", description="Get information of a specific multi-user chat room.", responses={@ApiResponse(responseCode="200", description="The chat room", content={@Content(schema=@Schema(implementation=MUCRoomEntity.class))}), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Produces(value={"application/xml", "application/json"})
    public MUCRoomEntity getMUCRoomJSON2(@Parameter(description="The name of the MUC room to return.", example="lobby", required=true) @PathParam(value="roomName") String roomName, @Parameter(description="The name of the MUC service for which to return a chat room.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @Parameter(description="For all groups defined in owners, admins, members and outcasts, list individual members instead of the group name.", required=false) @DefaultValue(value="false") @QueryParam(value="expandGroups") Boolean expand) throws ServiceException {
        roomName = JID.nodeprep((String)roomName);
        return MUCRoomController.getInstance().getChatRoom(roomName, serviceName, expand);
    }

    @Operation(summary="Delete chat room", description="Removes an existing multi-user chat room.", responses={@ApiResponse(responseCode="200", description="Room deleted."), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @DELETE
    @Path(value="/{roomName}")
    public Response deleteMUCRoom(@Parameter(description="The name of the MUC room to delete.", example="lobby", required=true) @PathParam(value="roomName") String roomName, @Parameter(description="The name of the MUC service from which to delete a chat room.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName) throws ServiceException {
        roomName = JID.nodeprep((String)roomName);
        MUCRoomController.getInstance().deleteChatRoom(roomName, serviceName);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Operation(summary="Create chat room", description="Create a new multi-user chat room.", responses={@ApiResponse(responseCode="201", description="Room created."), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Room creation is not permitted.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="MUC Service does not exist or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Room already exists, or another conflict occurred while creating the room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Consumes(value={"application/xml", "application/json"})
    public Response createMUCRoom(@Parameter(description="The name of the MUC service in which to create a chat room.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @Parameter(description="Whether to send invitations to affiliated users.", example="true", required=false) @DefaultValue(value="false") @QueryParam(value="sendInvitations") boolean sendInvitations, @RequestBody(description="The MUC room that needs to be created.", required=true) MUCRoomEntity mucRoomEntity) throws ServiceException {
        MUCRoomController.getInstance().createChatRoom(serviceName, mucRoomEntity, sendInvitations);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @POST
    @Path(value="/bulk")
    @Operation(summary="Create multiple chat rooms", description="Create a number of new multi-user chat rooms.", responses={@ApiResponse(responseCode="200", description="Request has been processed. Results are reported in the response.", content={@Content(schema=@Schema(implementation=RoomCreationResultEntities.class))}), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="MUC Service does not exist or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public RoomCreationResultEntities createMUCRooms(@Parameter(description="The name of the MUC service in which to create a chat room.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @Parameter(description="Whether to send invitations to newly affiliated users.", example="true", required=false) @DefaultValue(value="false") @QueryParam(value="sendInvitations") boolean sendInvitations, @RequestBody(description="The MUC rooms that need to be created.", required=true) MUCRoomEntities mucRoomEntities) throws ServiceException {
        return MUCRoomController.getInstance().createMultipleChatRooms(serviceName, mucRoomEntities, sendInvitations);
    }

    @PUT
    @Path(value="/{roomName}")
    @Operation(summary="Update chat room", description="Updates an existing multi-user chat room.", responses={@ApiResponse(responseCode="200", description="Room updated."), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Room update/create is not permitted.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="MUC Service does not exist or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="This update causes a conflict, possibly with another existing room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Consumes(value={"application/xml", "application/json"})
    public Response updateMUCRoom(@Parameter(description="The name of the chat room that needs to be updated", example="lobby", required=true) @PathParam(value="roomName") String roomName, @Parameter(description="The name of the MUC service in which to update a chat room.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @Parameter(description="Whether to send invitations to newly affiliated users.", example="true", required=false) @DefaultValue(value="false") @QueryParam(value="sendInvitations") boolean sendInvitations, @RequestBody(description="The new MUC room definition that needs to overwrite the old definition.", required=true) MUCRoomEntity mucRoomEntity) throws ServiceException {
        roomName = JID.nodeprep((String)roomName);
        MUCRoomController.getInstance().updateChatRoom(roomName, serviceName, mucRoomEntity, sendInvitations);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/{roomName}/participants")
    @Operation(summary="Get room participants", description="Get all participants of a specific multi-user chat room.", responses={@ApiResponse(responseCode="200", description="The chat room participants", content={@Content(schema=@Schema(implementation=ParticipantEntities.class))}), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Produces(value={"application/xml", "application/json"})
    public ParticipantEntities getMUCRoomParticipants(@Parameter(description="The name of the chat room for which to return participants", example="lobby", required=true) @PathParam(value="roomName") String roomName, @Parameter(description="The name of the chat room's MUC service.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName) throws ServiceException {
        roomName = JID.nodeprep((String)roomName);
        return MUCRoomController.getInstance().getRoomParticipants(roomName, serviceName);
    }

    @GET
    @Path(value="/{roomName}/occupants")
    @Operation(summary="Get room occupants", description="Get all occupants of a specific multi-user chat room.", responses={@ApiResponse(responseCode="200", description="The chat room participants", content={@Content(schema=@Schema(implementation=OccupantEntities.class))}), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Produces(value={"application/xml", "application/json"})
    public OccupantEntities getMUCRoomOccupants(@Parameter(description="The name of the chat room for which to return occupants", example="lobby", required=true) @PathParam(value="roomName") String roomName, @Parameter(description="The name of the chat room's MUC service.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName) throws ServiceException {
        roomName = JID.nodeprep((String)roomName);
        return MUCRoomController.getInstance().getRoomOccupants(roomName, serviceName);
    }

    @GET
    @Path(value="/{roomName}/chathistory")
    @Operation(summary="Get room history", description="Get messages that have been exchanged in a specific multi-user chat room.", responses={@ApiResponse(responseCode="200", description="The chat room message history", content={@Content(schema=@Schema(implementation=MUCRoomMessageEntities.class))}), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Produces(value={"application/xml", "application/json"})
    public MUCRoomMessageEntities getMUCRoomHistory(@Parameter(description="The name of the chat room for which to return message history", example="lobby", required=true) @PathParam(value="roomName") String roomName, @Parameter(description="The name of the chat room's MUC service.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName) throws ServiceException {
        roomName = JID.nodeprep((String)roomName);
        return MUCRoomController.getInstance().getRoomHistory(roomName, serviceName);
    }

    @POST
    @Path(value="/{roomName}/invite/{jid}")
    @Operation(summary="Invite user or group", description="Invites a user or group to join a specific multi-user chat room.", responses={@ApiResponse(responseCode="200", description="Invitation sent"), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Not allowed to invite a user to this room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Consumes(value={"application/xml", "application/json"})
    public Response inviteUserOrGroupToMUCRoom(@Parameter(description="The name of the chat room in which to invite a user or group", example="lobby", required=true) @PathParam(value="roomName") String roomName, @Parameter(description="The JID of the entity to invite into the room", example="john@example.org", required=true) @PathParam(value="jid") String jid, @Parameter(description="The name of the chat room's MUC service.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @RequestBody(description="The invitation message to send and whom to send it to.", required=true) MUCInvitationEntity mucInvitationEntity) throws ServiceException {
        roomName = JID.nodeprep((String)roomName);
        MUCInvitationsEntity multiple = new MUCInvitationsEntity();
        multiple.setReason(mucInvitationEntity.getReason());
        if (!multiple.getJidsToInvite().contains(jid)) {
            multiple.getJidsToInvite().add(jid);
        }
        MUCRoomController.getInstance().inviteUsersAndOrGroups(serviceName, roomName, multiple);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/{roomName}/invite")
    @Operation(summary="Invite a collection of users and/or groups", description="Invites a collection of users and/or groups to join a specific multi-user chat room.", responses={@ApiResponse(responseCode="200", description="Invitation sent"), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Not allowed to invite a user or group to this room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Consumes(value={"application/xml", "application/json"})
    public Response inviteUsersAndOrGroupsToMUCRoom(@Parameter(description="The name of the chat room in which to invite a user or group", example="lobby", required=true) @PathParam(value="roomName") String roomName, @Parameter(description="The name of the chat room's MUC service.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @RequestBody(description="The invitation message to send and whom to send it to.", required=true) MUCInvitationsEntity mucInvitationsEntity) throws ServiceException {
        roomName = JID.nodeprep((String)roomName);
        MUCRoomController.getInstance().inviteUsersAndOrGroups(serviceName, roomName, mucInvitationsEntity);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

