/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.plugin.rest.controller.MUCRoomController;
import org.jivesoftware.openfire.plugin.rest.entity.AdminEntities;
import org.jivesoftware.openfire.plugin.rest.entity.AffiliatedEntities;
import org.jivesoftware.openfire.plugin.rest.entity.MemberEntities;
import org.jivesoftware.openfire.plugin.rest.entity.OutcastEntities;
import org.jivesoftware.openfire.plugin.rest.entity.OwnerEntities;
import org.jivesoftware.openfire.plugin.rest.exceptions.ErrorResponse;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.openfire.plugin.rest.utils.MUCRoomUtils;
import org.xmpp.packet.JID;

@Path(value="restapi/v1/chatrooms/{roomName}/{affiliation: (admins|members|outcasts|owners)}")
@Tag(name="Chat room", description="Managing Multi-User chat rooms.")
public class MUCRoomAffiliationsService {
    @GET
    @Path(value="/")
    @Operation(summary="All room affiliations", description="Retrieves a list of JIDs for all affiliated users of a multi-user chat room.", responses={@ApiResponse(responseCode="200", description="Affiliated user list retrieved."), @ApiResponse(responseCode="400", description="Provided 'affiliations' value is invalid."), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    public Response getAffiliations(@Parameter(description="The name of the MUC service that the MUC room is part of.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @Parameter(description="The name of the MUC room for which to return affiliations.", example="lobby", required=true) @PathParam(value="roomName") String roomName, @Parameter(description="The type of affiliation. One of: 'admins', 'members', 'outcasts', 'owners' .", example="members", required=true) @PathParam(value="affiliation") String affiliations) throws ServiceException {
        AffiliatedEntities result;
        MUCRole.Affiliation affiliation;
        roomName = JID.nodeprep((String)roomName);
        try {
            affiliation = MUCRoomUtils.convertPluralStringToAffiliation(affiliations);
        }
        catch (RuntimeException e) {
            throw new ServiceException("Invalid 'affiliations' value: " + affiliations, roomName, "IllegalArgumentException", Response.Status.BAD_REQUEST);
        }
        List<String> results = MUCRoomController.getInstance().getByAffiliation(serviceName, roomName, affiliation).stream().map(JID::toBareJID).collect(Collectors.toList());
        switch (affiliation) {
            case admin: {
                result = new AdminEntities(results);
                break;
            }
            case member: {
                result = new MemberEntities(results);
                break;
            }
            case owner: {
                result = new OwnerEntities(results);
                break;
            }
            case outcast: {
                result = new OutcastEntities(results);
                break;
            }
            default: {
                throw new ServiceException("Unrecognized affiliation: " + affiliation, roomName, "IllegalArgumentException", Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        return Response.ok((Object)result).build();
    }

    @PUT
    @Path(value="/")
    @Operation(summary="Replace room affiliations", description="Replaces the list of users in a multi-user chat room with a specific affiliation with a new list of users. Note that a user can only have one type of affiliation with a room. By affiliating a user to a room, any other pre-existing affiliation for that user is removed.", responses={@ApiResponse(responseCode="201", description="Affiliations of the room have been replaced."), @ApiResponse(responseCode="400", description="Provided values cannot be parsed as JIDs, or provided 'affiliations' value is invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Not allowed to perform this affiliation change.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Consumes(value={"application/xml", "application/json"})
    public Response replaceMUCRoomAffiliation(@Parameter(description="The name of the MUC service that the MUC room is part of.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @Parameter(description="The name of the MUC room of which affiliations are to be replaced.", example="lobby", required=true) @PathParam(value="roomName") String roomName, @Parameter(description="The type of affiliation. One of: 'admins', 'members', 'outcasts', 'owners' .", example="members", required=true) @PathParam(value="affiliation") String affiliations, @Parameter(description="Whether to send invitations to new admin users.", example="true", required=false) @DefaultValue(value="false") @QueryParam(value="sendInvitations") boolean sendInvitations, @RequestBody(description="The new list of users with this particular affiliation.", required=true) AffiliatedEntities affiliatedEntities) throws ServiceException {
        MUCRole.Affiliation affiliation;
        roomName = JID.nodeprep((String)roomName);
        try {
            affiliation = MUCRoomUtils.convertPluralStringToAffiliation(affiliations);
        }
        catch (RuntimeException e) {
            throw new ServiceException("Invalid 'affiliations' value: " + affiliations, roomName, "IllegalArgumentException", Response.Status.BAD_REQUEST);
        }
        MUCRoomController.getInstance().replaceAffiliatedUsers(serviceName, roomName, affiliation, sendInvitations, affiliatedEntities.asUserReferences());
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @POST
    @Path(value="/")
    @Operation(summary="Add room affiliations", description="Affiliatione multiple users to a particular multi-user chat room (without removing existing affiliated users of that type). Note that a user can only have one type of affiliation with a room. By affiliating a user to a room, any other pre-existing affiliation for that user is removed.", responses={@ApiResponse(responseCode="201", description="Users have been affiliated to the room."), @ApiResponse(responseCode="400", description="Provided values cannot be parsed as JIDs, or provided 'affiliations' value is invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Not allowed to perform this affiliation change.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Consumes(value={"application/xml", "application/json"})
    public Response addMUCRoomAffiliations(@Parameter(description="The name of the MUC service that the MUC room is part of.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @Parameter(description="The name of the MUC room to which users are to be affiliated.", example="lobby", required=true) @PathParam(value="roomName") String roomName, @Parameter(description="The type of affiliation. One of: 'admins', 'members', 'outcasts', 'owners' .", example="members", required=true) @PathParam(value="affiliation") String affiliations, @Parameter(description="Whether to send invitations to new admin users.", example="true", required=false) @DefaultValue(value="false") @QueryParam(value="sendInvitations") boolean sendInvitations, @RequestBody(description="The list of users to affiliate to the room.", required=true) AffiliatedEntities affiliatedEntities) throws ServiceException {
        MUCRole.Affiliation affiliation;
        roomName = JID.nodeprep((String)roomName);
        try {
            affiliation = MUCRoomUtils.convertPluralStringToAffiliation(affiliations);
        }
        catch (RuntimeException e) {
            throw new ServiceException("Invalid 'affiliations' value: " + affiliations, roomName, "IllegalArgumentException", Response.Status.BAD_REQUEST);
        }
        MUCRoomController.getInstance().addAffiliatedUsers(serviceName, roomName, affiliation, sendInvitations, affiliatedEntities.asUserReferences());
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @POST
    @Path(value="/{jid}")
    @Operation(summary="Add room affiliation", description="Affiliates a single use to a multi-user chat room. Note that a user can only have one type of affiliation with a room. By affiliating a user to a room, any other pre-existing affiliation for that user is removed.", responses={@ApiResponse(responseCode="201", description="User to affiliate to the room."), @ApiResponse(responseCode="400", description="Provided 'affiliations' value is invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Not allowed to perform this affiliation change.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    public Response addMUCRoomAffiliation(@Parameter(description="The name of the MUC service that the MUC room is part of.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @Parameter(description="The (bare) JID of the entity that is to be affiliated.", example="john@example.org", required=true) @PathParam(value="jid") String jid, @Parameter(description="The type of affiliation. One of: 'admins', 'members', 'outcasts', 'owners' .", example="members", required=true) @PathParam(value="affiliation") String affiliations, @Parameter(description="The name of the MUC room to which an affiliation is to be added.", example="lobby", required=true) @PathParam(value="roomName") String roomName, @Parameter(description="Whether to send invitations to new admin users.", example="true", required=false) @DefaultValue(value="false") @QueryParam(value="sendInvitations") boolean sendInvitations) throws ServiceException {
        MUCRole.Affiliation affiliation;
        roomName = JID.nodeprep((String)roomName);
        try {
            affiliation = MUCRoomUtils.convertPluralStringToAffiliation(affiliations);
        }
        catch (RuntimeException e) {
            throw new ServiceException("Invalid 'affiliations' value: " + affiliations, roomName, "IllegalArgumentException", Response.Status.BAD_REQUEST);
        }
        MUCRoomController.getInstance().addAffiliatedUsers(serviceName, roomName, affiliation, sendInvitations, jid);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @POST
    @Path(value="/group/{groupname}")
    @Operation(summary="Add room affiliations", description="Affiliate all members of an Openfire user group to a multi-user chat room. Note that a user can only have one type of affiliation with a room. By affiliating a user to a room, any other pre-existing affiliation for that user is removed.", responses={@ApiResponse(responseCode="201", description="Affiliations added to the room."), @ApiResponse(responseCode="400", description="Provided 'affiliations' value is invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Not allowed to perform this affiliation change.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    public Response addMUCRoomAffiliationGroup(@Parameter(description="The name of the MUC service that the MUC room is part of.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @Parameter(description="The name of the user group from which all members will be affiliated to the room.", example="Operators", required=true) @PathParam(value="groupname") String groupname, @Parameter(description="The type of affiliation. One of: 'admins', 'members', 'outcasts', 'owners' .", example="members", required=true) @PathParam(value="affiliation") String affiliations, @Parameter(description="The name of the MUC room to which affiliations are to be added.", example="lobby", required=true) @PathParam(value="roomName") String roomName, @Parameter(description="Whether to send invitations to new admin users.", example="true", required=false) @DefaultValue(value="false") @QueryParam(value="sendInvitations") boolean sendInvitations) throws ServiceException {
        MUCRole.Affiliation affiliation;
        roomName = JID.nodeprep((String)roomName);
        try {
            affiliation = MUCRoomUtils.convertPluralStringToAffiliation(affiliations);
        }
        catch (RuntimeException e) {
            throw new ServiceException("Invalid 'affiliations' value: " + affiliations, roomName, "IllegalArgumentException", Response.Status.BAD_REQUEST);
        }
        MUCRoomController.getInstance().addAffiliatedUsers(serviceName, roomName, affiliation, sendInvitations, groupname);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    @Path(value="/{jid}")
    @Operation(summary="Remove room affiliation", description="Removes an affiliation of a user to a multi-user chat room.", responses={@ApiResponse(responseCode="200", description="Affiliation removed from the room."), @ApiResponse(responseCode="400", description="Provided 'affiliations' value is invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Not allowed to remove this affiliation.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Applying this affiliation change would cause a room conflict.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    public Response deleteMUCRoomAffiliation(@Parameter(description="The (bare) JID of the entity for which the room affiliation is to be removed.", example="john@example.org", required=true) @PathParam(value="jid") String jid, @Parameter(description="The name of the MUC service that the MUC room is part of.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @Parameter(description="The type of affiliation. One of: 'admins', 'members', 'outcasts', 'owners' .", example="members", required=true) @PathParam(value="affiliation") String affiliations, @Parameter(description="The name of the MUC room from which an affiliation is to be removed.", example="lobby", required=true) @PathParam(value="roomName") String roomName) throws ServiceException {
        MUCRole.Affiliation affiliation;
        roomName = JID.nodeprep((String)roomName);
        try {
            affiliation = MUCRoomUtils.convertPluralStringToAffiliation(affiliations);
        }
        catch (RuntimeException e) {
            throw new ServiceException("Invalid 'affiliations' value: " + affiliations, roomName, "IllegalArgumentException", Response.Status.BAD_REQUEST);
        }
        MUCRoomController.getInstance().deleteAffiliation(serviceName, roomName, affiliation, jid);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/group/{groupname}")
    @Operation(summary="Remove room affiliations", description="Removes affiliation for all members of an Openfire user group from a multi-user chat room.", responses={@ApiResponse(responseCode="200", description="Affiliations removed from the room."), @ApiResponse(responseCode="401", description="Web service authentication failed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="400", description="Provided 'affiliations' value is invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Not allowed to remove this affiliation.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="The chat room (or its service) can not be found or is not accessible.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="Applying this affiliation change would cause a room conflict.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Unexpected, generic error condition.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    public Response deleteMUCRoomAffiliationGroup(@Parameter(description="The name of the user group from which all members will get their room affiliation removed.", example="Operators", required=true) @PathParam(value="groupname") String groupname, @Parameter(description="The name of the MUC service that the MUC room is part of.", example="conference", required=false) @DefaultValue(value="conference") @QueryParam(value="servicename") String serviceName, @Parameter(description="The type of affiliation. One of: 'admins', 'members', 'outcasts', 'owners' .", example="members", required=true) @PathParam(value="affiliation") String affiliations, @Parameter(description="The name of the MUC room from which affiliations are to be removed.", example="lobby", required=true) @PathParam(value="roomName") String roomName) throws ServiceException {
        MUCRole.Affiliation affiliation;
        roomName = JID.nodeprep((String)roomName);
        try {
            affiliation = MUCRoomUtils.convertPluralStringToAffiliation(affiliations);
        }
        catch (RuntimeException e) {
            throw new ServiceException("Invalid 'affiliations' value: " + affiliations, roomName, "IllegalArgumentException", Response.Status.BAD_REQUEST);
        }
        MUCRoomController.getInstance().deleteAffiliation(serviceName, roomName, affiliation, groupname);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

