/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="group")
@XmlType(propOrder={"name", "description", "admins", "members", "shared"})
public class GroupEntity {
    private String name;
    private String description;
    private List<String> admins;
    private List<String> members;
    private Boolean shared = false;

    public GroupEntity() {
    }

    public GroupEntity(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @XmlElement
    @Schema(description="Name of the group", example="UserGroup1")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    @Schema(description="Description of the group", example="My group of users")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElementWrapper(name="admins")
    @XmlElement(name="admin")
    @JsonProperty(value="admins")
    @ArraySchema(schema=@Schema(example="jane.smith"), arraySchema=@Schema(description="List of admins of the group"))
    public List<String> getAdmins() {
        return this.admins;
    }

    @XmlElementWrapper(name="members")
    @XmlElement(name="member")
    @JsonProperty(value="members")
    @ArraySchema(schema=@Schema(example="john.jones"), arraySchema=@Schema(description="List of members of the group"))
    public List<String> getMembers() {
        return this.members;
    }

    public void setAdmins(List<String> admins) {
        this.admins = admins;
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }

    @XmlElement(name="shared")
    @Schema(description="Whether the group should automatically appear in the rosters of the users", example="false")
    public Boolean getShared() {
        return this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }
}

