/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.dom4j.Element;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.ConcurrentGroupList;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.muc.CannotBeInvitedException;
import org.jivesoftware.openfire.muc.ConflictException;
import org.jivesoftware.openfire.muc.ForbiddenException;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.MUCRoomHistory;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.NotAllowedException;
import org.jivesoftware.openfire.muc.spi.MUCRoomSearchInfo;
import org.jivesoftware.openfire.plugin.rest.controller.MUCServiceController;
import org.jivesoftware.openfire.plugin.rest.entity.MUCInvitationsEntity;
import org.jivesoftware.openfire.plugin.rest.entity.MUCRoomEntities;
import org.jivesoftware.openfire.plugin.rest.entity.MUCRoomEntity;
import org.jivesoftware.openfire.plugin.rest.entity.MUCRoomMessageEntities;
import org.jivesoftware.openfire.plugin.rest.entity.MUCRoomMessageEntity;
import org.jivesoftware.openfire.plugin.rest.entity.OccupantEntities;
import org.jivesoftware.openfire.plugin.rest.entity.OccupantEntity;
import org.jivesoftware.openfire.plugin.rest.entity.ParticipantEntities;
import org.jivesoftware.openfire.plugin.rest.entity.ParticipantEntity;
import org.jivesoftware.openfire.plugin.rest.entity.RoomCreationResultEntities;
import org.jivesoftware.openfire.plugin.rest.entity.RoomCreationResultEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.openfire.plugin.rest.utils.MUCRoomUtils;
import org.jivesoftware.openfire.plugin.rest.utils.UserUtils;
import org.jivesoftware.util.AlreadyExistsException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.SystemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class MUCRoomController {
    private static final Logger LOG = LoggerFactory.getLogger(MUCRoomController.class);
    public static final SystemProperty<Boolean> ROOM_NAME_CASE_INSENSITIVE_LOOKUP_ENABLED = SystemProperty.Builder.ofType(Boolean.class).setPlugin("REST API").setKey("plugin.restapi.muc.case-insensitive-lookup.enabled").setDefaultValue((Object)false).setDynamic(true).build();
    private static MUCRoomController INSTANCE = null;

    public static MUCRoomController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MUCRoomController();
        }
        return INSTANCE;
    }

    @Deprecated
    public static void setInstance(MUCRoomController instance) {
        INSTANCE = instance;
    }

    public static void log(String logMessage) {
        if (JiveGlobals.getBooleanProperty((String)"plugin.restapi.serviceLoggingEnabled", (boolean)false)) {
            LOG.info(logMessage);
        }
    }

    public static void log(String logMessage, Throwable t) {
        if (JiveGlobals.getBooleanProperty((String)"plugin.restapi.serviceLoggingEnabled", (boolean)false)) {
            LOG.info(logMessage, t);
        }
    }

    @Nonnull
    protected static MUCRoom getRoom(@Nonnull String serviceName, @Nonnull String roomName) throws ServiceException {
        MultiUserChatService service = MUCServiceController.getService(serviceName);
        MUCRoom room = service.getChatRoom(JID.nodeprep((String)roomName));
        if (room == null && ((Boolean)ROOM_NAME_CASE_INSENSITIVE_LOOKUP_ENABLED.getValue()).booleanValue()) {
            for (String name : service.getAllRoomNames()) {
                if (name.equalsIgnoreCase(roomName) && (room = service.getChatRoom(roomName)) != null) {
                    LOG.info("Could not find a case-sensitive match for room '{}', but did find a case-insensitive match: '{}'. Case insensitive lookups are resource intensive. Verify that your database contains properly node-prepped MUC room names.", (Object)roomName, (Object)room.getName());
                    return room;
                }
                if (!JID.nodeprep((String)name).equalsIgnoreCase(roomName) || (room = service.getChatRoom(roomName)) == null) continue;
                LOG.info("Could not find a case-sensitive match for room '{}', but did find a case-insensitive match after node-prepping: '{}'. Case insensitive lookups are resource intensive. Verify that your database contains properly node-prepped MUC room names.", (Object)roomName, (Object)room.getName());
                return room;
            }
        }
        if (room == null) {
            throw new ServiceException("Chat room does not exist or is not accessible.", roomName, "RoomNotFoundException", Response.Status.NOT_FOUND);
        }
        return room;
    }

    public MUCRoomEntities getChatRooms(String serviceName, String channelType, String roomSearch, boolean expand) throws ServiceException {
        MUCRoomController.log("Get the chat rooms");
        MultiUserChatService service = MUCServiceController.getService(serviceName);
        Collection roomsInfo = service.getAllRoomSearchInfo();
        ArrayList<MUCRoomEntity> mucRoomEntities = new ArrayList<MUCRoomEntity>();
        for (MUCRoomSearchInfo roomInfo : roomsInfo) {
            String roomName = roomInfo.getName();
            if (roomSearch != null && !StringUtils.containsIgnoringCase((String)roomInfo.getName(), (String)JID.nodeprep((String)roomSearch)) && !StringUtils.containsIgnoringCase((String)roomInfo.getNaturalLanguageName(), (String)roomSearch)) continue;
            MUCRoom chatRoom = service.getChatRoom(roomName);
            if (chatRoom == null) {
                LOG.warn("Cannot get room '{}' from service '{}' even though service's 'getAllRoomNames()' returns this name.", (Object)roomName, (Object)serviceName);
                continue;
            }
            if (channelType.equals("all")) {
                mucRoomEntities.add(this.convertToMUCRoomEntity(chatRoom, expand));
                continue;
            }
            if (!channelType.equals("public") || !chatRoom.isPublicRoom()) continue;
            mucRoomEntities.add(this.convertToMUCRoomEntity(chatRoom, expand));
        }
        return new MUCRoomEntities(mucRoomEntities);
    }

    public MUCRoomEntity getChatRoom(String roomName, String serviceName, boolean expand) throws ServiceException {
        MUCRoomController.log("Get the chat room: " + roomName);
        MUCRoom chatRoom = MUCRoomController.getRoom(serviceName, roomName);
        return this.convertToMUCRoomEntity(chatRoom, expand);
    }

    public void deleteChatRoom(String roomName, String serviceName) throws ServiceException {
        MUCRoomController.log("Delete the chat room: " + roomName);
        MUCRoom chatRoom = MUCRoomController.getRoom(serviceName, roomName);
        chatRoom.destroyRoom(null, null);
    }

    public void createChatRoom(String serviceName, MUCRoomEntity mucRoomEntity, boolean sendInvitations) throws ServiceException {
        MUCRoomController.log("Create a chat room: " + mucRoomEntity.getRoomName());
        try {
            this.createRoom(mucRoomEntity, serviceName, sendInvitations);
        }
        catch (ForbiddenException | NotAllowedException e) {
            throw new ServiceException("Could not create the channel", mucRoomEntity.getRoomName(), "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ConflictException e) {
            throw new ServiceException("Could not create the channel", mucRoomEntity.getRoomName(), "NotAllowedException", Response.Status.CONFLICT, e);
        }
        catch (AlreadyExistsException e) {
            throw new ServiceException("Could not create the channel", mucRoomEntity.getRoomName(), "AlreadyExistsException", Response.Status.CONFLICT, e);
        }
    }

    public RoomCreationResultEntities createMultipleChatRooms(String serviceName, MUCRoomEntities mucRoomEntities, boolean sendInvitations) throws ServiceException {
        List<MUCRoomEntity> roomsToCreate = mucRoomEntities.getMucRooms();
        MUCRoomController.log("Create " + roomsToCreate.size() + " chat rooms");
        ArrayList<RoomCreationResultEntity> results = new ArrayList<RoomCreationResultEntity>();
        for (MUCRoomEntity roomToCreate : roomsToCreate) {
            RoomCreationResultEntity result = new RoomCreationResultEntity();
            result.setRoomName(roomToCreate.getRoomName());
            try {
                this.createRoom(roomToCreate, serviceName, sendInvitations);
                result.setResultType(RoomCreationResultEntity.RoomCreationResultType.Success);
                result.setMessage("Room was successfully created");
            }
            catch (AlreadyExistsException e) {
                MUCRoomController.log("Already exists exception thrown while trying to create room: " + roomToCreate.getRoomName(), e);
                result.setResultType(RoomCreationResultEntity.RoomCreationResultType.Success);
                result.setMessage("Room already existed and therefore not created again");
            }
            catch (ConflictException | ForbiddenException | NotAllowedException e) {
                MUCRoomController.log("Failed to create room: " + roomToCreate.getRoomName(), e);
                result.setResultType(RoomCreationResultEntity.RoomCreationResultType.Failure);
                result.setMessage("Room creation failed due to " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
            results.add(result);
        }
        return new RoomCreationResultEntities(results);
    }

    public void updateChatRoom(String roomName, String serviceName, MUCRoomEntity mucRoomEntity, boolean sendInvitations) throws ServiceException {
        MUCRoomController.log("Update a chat room: " + mucRoomEntity.getRoomName());
        try {
            if (!JID.nodeprep((String)roomName).equals(mucRoomEntity.getRoomName())) {
                throw new ServiceException("Could not update the channel. The room name is different to the entity room name.", roomName, "IllegalArgumentException", Response.Status.BAD_REQUEST);
            }
            this.createRoom(mucRoomEntity, serviceName, sendInvitations);
        }
        catch (ForbiddenException | NotAllowedException e) {
            MUCRoomController.log("Failed to update room: " + mucRoomEntity.getRoomName(), e);
            throw new ServiceException("Could not update the channel", roomName, "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ConflictException e) {
            MUCRoomController.log("Failed to update room: " + mucRoomEntity.getRoomName(), e);
            throw new ServiceException("Could not update the channel", roomName, "NotAllowedException", Response.Status.CONFLICT, e);
        }
        catch (AlreadyExistsException e) {
            MUCRoomController.log("Already exists exception thrown while trying to update room: " + mucRoomEntity.getRoomName(), e);
            throw new ServiceException("Could not update the channel", mucRoomEntity.getRoomName(), "AlreadyExistsException", Response.Status.CONFLICT, e);
        }
    }

    private void createRoom(MUCRoomEntity mucRoomEntity, String serviceName, boolean sendInvitations) throws NotAllowedException, ForbiddenException, ConflictException, AlreadyExistsException, ServiceException {
        MUCRoomController.log("Create or updating a chat room: " + mucRoomEntity.getRoomName());
        JID owner = XMPPServer.getInstance().createJID("admin", null);
        if (mucRoomEntity.getOwners() != null && mucRoomEntity.getOwners().size() > 0) {
            owner = new JID(mucRoomEntity.getOwners().get(0));
        } else {
            MUCRoomController.log("Room '" + mucRoomEntity.getRoomName() + "' is being created/updated without an owner. Adding default owner (as having an owner is non-optional).");
            ArrayList<String> owners = new ArrayList<String>();
            owners.add(owner.toBareJID());
            mucRoomEntity.setOwners(owners);
        }
        LinkedList<JID> allRequestedAffiliations = new LinkedList<JID>();
        if (mucRoomEntity.getOwners() != null) {
            allRequestedAffiliations.addAll(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getOwners()));
        }
        if (mucRoomEntity.getAdmins() != null) {
            allRequestedAffiliations.addAll(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getAdmins()));
        }
        if (mucRoomEntity.getMembers() != null) {
            allRequestedAffiliations.addAll(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getMembers()));
        }
        if (mucRoomEntity.getOutcasts() != null) {
            allRequestedAffiliations.addAll(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getOutcasts()));
        }
        HashSet uniques = new HashSet();
        Set duplicates = allRequestedAffiliations.stream().filter(n -> !uniques.add(n)).map(JID::toString).collect(Collectors.toSet());
        if (!duplicates.isEmpty()) {
            throw new ConflictException("The requested room defines duplicate affiliations for the following entities: " + String.join((CharSequence)", ", duplicates));
        }
        boolean serviceRegistered = XMPPServer.getInstance().getMultiUserChatManager().isServiceRegistered(serviceName);
        if (!serviceRegistered) {
            MUCRoomController.log("Creating a new service for the chat room that is being created: " + serviceName);
            XMPPServer.getInstance().getMultiUserChatManager().createMultiUserChatService(serviceName, serviceName, false);
        }
        MUCRoomController.log("Setting initial values for room that is being created/updated: " + mucRoomEntity.getRoomName());
        MUCRoom room = MUCServiceController.getService(serviceName).getChatRoom(mucRoomEntity.getRoomName(), owner);
        MUCRoomController.log("Room " + mucRoomEntity.getRoomName() + " is being " + (room.isLocked() ? "created" : "updated"));
        room.setNaturalLanguageName(mucRoomEntity.getNaturalName());
        room.setSubject(mucRoomEntity.getSubject());
        room.setDescription(mucRoomEntity.getDescription());
        room.setPassword(mucRoomEntity.getPassword());
        room.setPersistent(mucRoomEntity.isPersistent());
        room.setPublicRoom(mucRoomEntity.isPublicRoom());
        room.setRegistrationEnabled(mucRoomEntity.isRegistrationEnabled());
        room.setCanAnyoneDiscoverJID(mucRoomEntity.isCanAnyoneDiscoverJID());
        room.setCanOccupantsChangeSubject(mucRoomEntity.isCanOccupantsChangeSubject());
        room.setCanOccupantsInvite(mucRoomEntity.isCanOccupantsInvite());
        room.setChangeNickname(mucRoomEntity.isCanChangeNickname());
        room.setModificationDate(mucRoomEntity.getModificationDate());
        room.setLogEnabled(mucRoomEntity.isLogEnabled());
        room.setLoginRestrictedToNickname(mucRoomEntity.isLoginRestrictedToNickname());
        room.setMaxUsers(mucRoomEntity.getMaxUsers());
        room.setMembersOnly(mucRoomEntity.isMembersOnly());
        room.setModerated(mucRoomEntity.isModerated());
        room.setCanSendPrivateMessage(mucRoomEntity.getAllowPM());
        if (mucRoomEntity.getBroadcastPresenceRoles() != null) {
            room.setRolesToBroadcastPresence(MUCRoomUtils.convertStringsToRoles(mucRoomEntity.getBroadcastPresenceRoles()));
        } else {
            room.setRolesToBroadcastPresence(new ArrayList());
        }
        MUCRoomController.log("Setting roles for room that is being " + (room.isLocked() ? "created" : "updated") + ": " + mucRoomEntity.getRoomName());
        Collection<JID> allUsersWithNewAffiliations = null;
        if (!this.equalToAffiliations(room, mucRoomEntity)) {
            allUsersWithNewAffiliations = MUCRoomController.setRoles(room, mucRoomEntity);
        }
        if (mucRoomEntity.getCreationDate() != null) {
            room.setCreationDate(mucRoomEntity.getCreationDate());
        } else {
            room.setCreationDate(new Date());
        }
        if (mucRoomEntity.getModificationDate() != null) {
            room.setModificationDate(mucRoomEntity.getModificationDate());
        } else {
            room.setModificationDate(new Date());
        }
        MUCRoomController.log("Unlocking room that is being " + (room.isLocked() ? "created" : "updated") + ": " + mucRoomEntity.getRoomName());
        room.unlock(room.getRole());
        if (room.isPersistent()) {
            MUCRoomController.log("Persisting room that is being created/updated: " + mucRoomEntity.getRoomName());
            room.saveToDB();
        }
        MUCRoomController.log("Syncing room that is being created/updated: " + mucRoomEntity.getRoomName());
        MUCServiceController.getService(serviceName).syncChatRoom(room);
        if (sendInvitations && allUsersWithNewAffiliations != null) {
            MUCRoomController.log("Sending invitations for room that is being created/updated: " + mucRoomEntity.getRoomName());
            this.sendInvitationsFromRoom(room, null, allUsersWithNewAffiliations, null, true);
        }
        MUCRoomController.log("Done creating/updating room: " + mucRoomEntity.getRoomName());
    }

    private boolean equalToAffiliations(MUCRoom room, MUCRoomEntity mucRoomEntity) {
        if (mucRoomEntity == null || room == null) {
            return false;
        }
        ConcurrentGroupList owners = new ConcurrentGroupList(room.getOwners());
        ConcurrentGroupList admins = new ConcurrentGroupList(room.getAdmins());
        ConcurrentGroupList members = new ConcurrentGroupList(room.getMembers());
        ConcurrentGroupList outcasts = new ConcurrentGroupList(room.getOutcasts());
        HashSet<String> roomOwners = new HashSet<String>(MUCRoomUtils.convertJIDsToStringList((Collection<JID>)owners));
        HashSet<String> roomAdmins = new HashSet<String>(MUCRoomUtils.convertJIDsToStringList((Collection<JID>)admins));
        HashSet<String> roomMembers = new HashSet<String>(MUCRoomUtils.convertJIDsToStringList((Collection<JID>)members));
        HashSet<String> roomOutcasts = new HashSet<String>(MUCRoomUtils.convertJIDsToStringList((Collection<JID>)outcasts));
        HashSet<String> entityOwners = mucRoomEntity.getOwners() != null ? new HashSet<String>(mucRoomEntity.getOwners()) : new HashSet();
        HashSet<String> entityAdmins = mucRoomEntity.getAdmins() != null ? new HashSet<String>(mucRoomEntity.getAdmins()) : new HashSet();
        HashSet<String> entityMembers = mucRoomEntity.getMembers() != null ? new HashSet<String>(mucRoomEntity.getMembers()) : new HashSet();
        HashSet<String> entityOutcasts = mucRoomEntity.getOutcasts() != null ? new HashSet<String>(mucRoomEntity.getOutcasts()) : new HashSet();
        HashSet<String> roomOwnerGroups = new HashSet<String>(MUCRoomUtils.convertGroupsToStringList(owners.getGroups()));
        HashSet<String> roomAdminGroups = new HashSet<String>(MUCRoomUtils.convertGroupsToStringList(admins.getGroups()));
        HashSet<String> roomMemberGroups = new HashSet<String>(MUCRoomUtils.convertGroupsToStringList(members.getGroups()));
        HashSet<String> roomOutcastGroups = new HashSet<String>(MUCRoomUtils.convertGroupsToStringList(outcasts.getGroups()));
        HashSet<String> entityOwnerGroups = mucRoomEntity.getOwnerGroups() != null ? new HashSet<String>(mucRoomEntity.getOwnerGroups()) : new HashSet();
        HashSet<String> entityAdminGroups = mucRoomEntity.getAdminGroups() != null ? new HashSet<String>(mucRoomEntity.getAdminGroups()) : new HashSet();
        HashSet<String> entityMemberGroups = mucRoomEntity.getMemberGroups() != null ? new HashSet<String>(mucRoomEntity.getMemberGroups()) : new HashSet();
        HashSet<String> entityOutcastGroups = mucRoomEntity.getOutcastGroups() != null ? new HashSet<String>(mucRoomEntity.getOutcastGroups()) : new HashSet();
        return entityOwners.equals(roomOwners) && entityAdmins.equals(roomAdmins) && entityMembers.equals(roomMembers) && entityOutcasts.equals(roomOutcasts) && entityOwnerGroups.equals(roomOwnerGroups) && entityAdminGroups.equals(roomAdminGroups) && entityMemberGroups.equals(roomMemberGroups) && entityOutcastGroups.equals(roomOutcastGroups);
    }

    public ParticipantEntities getRoomParticipants(String roomName, String serviceName) throws ServiceException {
        MUCRoomController.log("Get room participants for room: " + roomName);
        ParticipantEntities participantEntities = new ParticipantEntities();
        ArrayList<ParticipantEntity> participants = new ArrayList<ParticipantEntity>();
        Collection serverParticipants = MUCRoomController.getRoom(serviceName, roomName).getParticipants();
        for (MUCRole role : serverParticipants) {
            ParticipantEntity participantEntity = new ParticipantEntity();
            participantEntity.setJid(role.getRoleAddress().toFullJID());
            participantEntity.setRole(role.getRole().name());
            participantEntity.setAffiliation(role.getAffiliation().name());
            participants.add(participantEntity);
        }
        participantEntities.setParticipants(participants);
        return participantEntities;
    }

    public OccupantEntities getRoomOccupants(String roomName, String serviceName) throws ServiceException {
        MUCRoomController.log("Get room occupants for room: " + roomName);
        OccupantEntities occupantEntities = new OccupantEntities();
        ArrayList<OccupantEntity> occupants = new ArrayList<OccupantEntity>();
        Collection serverOccupants = MUCRoomController.getRoom(serviceName, roomName).getOccupants();
        for (MUCRole role : serverOccupants) {
            OccupantEntity occupantEntity = new OccupantEntity();
            occupantEntity.setJid(role.getRoleAddress().toFullJID());
            occupantEntity.setUserAddress(role.getUserAddress().toFullJID());
            occupantEntity.setRole(role.getRole().name());
            occupantEntity.setAffiliation(role.getAffiliation().name());
            occupants.add(occupantEntity);
        }
        occupantEntities.setOccupants(occupants);
        return occupantEntities;
    }

    public MUCRoomMessageEntities getRoomHistory(String roomName, String serviceName) throws ServiceException {
        MUCRoomController.log("Get room history for room: " + roomName);
        MUCRoomMessageEntities mucRoomMessageEntities = new MUCRoomMessageEntities();
        ArrayList<MUCRoomMessageEntity> listMessages = new ArrayList<MUCRoomMessageEntity>();
        MUCRoom chatRoom = MUCRoomController.getRoom(serviceName, roomName);
        MUCRoomHistory mucRH = chatRoom.getRoomHistory();
        Iterator messageHistory = mucRH.getMessageHistory();
        while (messageHistory.hasNext()) {
            Element delay;
            Message message = (Message)messageHistory.next();
            MUCRoomMessageEntity mucMsgEntity = new MUCRoomMessageEntity();
            if (message.getTo() != null && message.getTo().toString().length() != 0) {
                mucMsgEntity.setTo(message.getTo().toString());
            }
            if (message.getFrom() != null && message.getFrom().toString().length() != 0) {
                mucMsgEntity.setFrom(message.getFrom().toFullJID());
            }
            if (message.getType() != null && message.getType().toString().length() != 0) {
                mucMsgEntity.setType(message.getType().name());
            }
            if (message.getBody() != null && message.getBody().length() != 0) {
                mucMsgEntity.setBody(message.getBody());
            }
            if ((delay = message.getChildElement("delay", "urn:xmpp:delay")) != null) {
                mucMsgEntity.setDelayStamp(delay.attributeValue("stamp"));
                String delayFrom = delay.attributeValue("from");
                if (delayFrom != null) {
                    mucMsgEntity.setDelayFrom(delayFrom);
                }
            }
            listMessages.add(mucMsgEntity);
        }
        mucRoomMessageEntities.setMessages(listMessages);
        return mucRoomMessageEntities;
    }

    public void inviteUsersAndOrGroups(String serviceName, String roomName, MUCInvitationsEntity mucInvitationsEntity) throws ServiceException {
        MUCRoom room = MUCRoomController.getRoom(serviceName, roomName);
        HashSet<JID> targetJIDs = new HashSet<JID>();
        for (String jidString : mucInvitationsEntity.getJidsToInvite()) {
            JID jid = UserUtils.checkAndGetJID(jidString);
            Group g = UserUtils.getGroupIfIsGroup(jid);
            if (g != null) {
                targetJIDs.addAll(g.getAll());
                continue;
            }
            targetJIDs.add(jid);
        }
        for (JID jid : targetJIDs) {
            try {
                room.sendInvitation(jid, mucInvitationsEntity.getReason(), room.getRole(), null);
            }
            catch (CannotBeInvitedException | ForbiddenException e) {
                throw new ServiceException("Could not invite user", jid.toString(), "NotAllowedException", Response.Status.FORBIDDEN, e);
            }
        }
    }

    private void sendInvitationsToSingleJID(MUCRoom room, EnumSet<MUCRole.Affiliation> affiliations, JID limitToThisUserOrGroup, String reason, boolean performAffiliationCheck) throws ForbiddenException {
        HashSet<JID> setOfOneJID = new HashSet<JID>();
        setOfOneJID.add(limitToThisUserOrGroup);
        this.sendInvitationsFromRoom(room, affiliations, setOfOneJID, reason, performAffiliationCheck);
    }

    private void sendInvitationsFromRoom(MUCRoom room, EnumSet<MUCRole.Affiliation> affiliations, Collection<JID> limitToTheseUsers, String reason, boolean performAffiliationCheck) throws ForbiddenException {
        Collection sendHere;
        if (affiliations == null) {
            affiliations = EnumSet.of(MUCRole.Affiliation.admin, MUCRole.Affiliation.member, MUCRole.Affiliation.owner);
        }
        MUCRole roomRole = MUCRole.createRoomRole((MUCRoom)room);
        if (affiliations.contains(MUCRole.Affiliation.admin)) {
            sendHere = limitToTheseUsers == null ? room.getAdmins() : limitToTheseUsers;
            for (JID roomAdmin : sendHere) {
                this.sendSingleInvitationFromRoom(roomAdmin, room, roomRole, MUCRole.Affiliation.admin, reason == null ? "You are admin of room " + room.getName() : reason, performAffiliationCheck ? (r, j) -> r.getAdmins().contains(j) : null);
            }
        }
        if (affiliations.contains(MUCRole.Affiliation.owner)) {
            sendHere = limitToTheseUsers == null ? room.getOwners() : limitToTheseUsers;
            for (JID roomOwner : sendHere) {
                this.sendSingleInvitationFromRoom(roomOwner, room, roomRole, MUCRole.Affiliation.owner, reason == null ? "You are owner of room " + room.getName() : reason, performAffiliationCheck ? (r, j) -> r.getOwners().contains(j) : null);
            }
        }
        if (affiliations.contains(MUCRole.Affiliation.member)) {
            sendHere = limitToTheseUsers == null ? room.getMembers() : limitToTheseUsers;
            for (JID roomMember : sendHere) {
                this.sendSingleInvitationFromRoom(roomMember, room, roomRole, MUCRole.Affiliation.member, reason == null ? "You are member of room " + room.getName() : reason, performAffiliationCheck ? (r, j) -> r.getMembers().contains(j) : null);
            }
        }
    }

    private void sendSingleInvitationFromRoom(JID sendHere, MUCRoom room, MUCRole roomRole, MUCRole.Affiliation affiliation, String invitationReason, BiFunction<MUCRoom, JID, Boolean> validation) throws ForbiddenException {
        boolean jidIsGroup = false;
        if (validation != null && !validation.apply(room, sendHere).booleanValue()) {
            MUCRoomController.log("User or group " + sendHere + " can not be invited to be " + affiliation + " of room " + room.getName() + " because it is not affiliated that way");
        } else {
            Group g = UserUtils.getGroupIfIsGroup(sendHere);
            if (g != null) {
                jidIsGroup = true;
                for (JID singleGroupMemberJID : g.getAll()) {
                    this.sendSingleInvitationFromRoom(singleGroupMemberJID, room, roomRole, affiliation, invitationReason, null);
                }
            }
            if (!jidIsGroup) {
                try {
                    room.sendInvitation(sendHere, invitationReason, roomRole, null);
                }
                catch (CannotBeInvitedException e) {
                    MUCRoomController.log("User " + sendHere + " can not be invited to be " + affiliation + " of room " + room.getName());
                }
            }
        }
    }

    public MUCRoomEntity convertToMUCRoomEntity(MUCRoom room, boolean expand) {
        MUCRoomEntity mucRoomEntity = new MUCRoomEntity(room.getNaturalLanguageName(), room.getName(), room.getDescription());
        mucRoomEntity.setSubject(room.getSubject());
        mucRoomEntity.setCanAnyoneDiscoverJID(room.canAnyoneDiscoverJID());
        mucRoomEntity.setCanChangeNickname(room.canChangeNickname());
        mucRoomEntity.setCanOccupantsChangeSubject(room.canOccupantsChangeSubject());
        mucRoomEntity.setCanOccupantsInvite(room.canOccupantsInvite());
        mucRoomEntity.setPublicRoom(room.isPublicRoom());
        mucRoomEntity.setPassword(room.getPassword());
        mucRoomEntity.setPersistent(room.isPersistent());
        mucRoomEntity.setRegistrationEnabled(room.isRegistrationEnabled());
        mucRoomEntity.setLogEnabled(room.isLogEnabled());
        mucRoomEntity.setLoginRestrictedToNickname(room.isLoginRestrictedToNickname());
        mucRoomEntity.setMaxUsers(room.getMaxUsers());
        mucRoomEntity.setMembersOnly(room.isMembersOnly());
        mucRoomEntity.setModerated(room.isModerated());
        mucRoomEntity.setAllowPM(room.canSendPrivateMessage());
        ConcurrentGroupList owners = new ConcurrentGroupList(room.getOwners());
        ConcurrentGroupList admins = new ConcurrentGroupList(room.getAdmins());
        ConcurrentGroupList members = new ConcurrentGroupList(room.getMembers());
        ConcurrentGroupList outcasts = new ConcurrentGroupList(room.getOutcasts());
        if (expand) {
            for (Group ownerGroup : owners.getGroups()) {
                owners.addAllAbsent(ownerGroup.getAll());
            }
            for (Group adminGroup : admins.getGroups()) {
                admins.addAllAbsent(adminGroup.getAll());
            }
            for (Group memberGroup : members.getGroups()) {
                members.addAllAbsent(memberGroup.getAll());
            }
            for (Group outcastGroup : outcasts.getGroups()) {
                outcasts.addAllAbsent(outcastGroup.getAll());
            }
        }
        mucRoomEntity.setOwners(MUCRoomUtils.convertJIDsToStringList((Collection<JID>)owners));
        mucRoomEntity.setAdmins(MUCRoomUtils.convertJIDsToStringList((Collection<JID>)admins));
        mucRoomEntity.setMembers(MUCRoomUtils.convertJIDsToStringList((Collection<JID>)members));
        mucRoomEntity.setOutcasts(MUCRoomUtils.convertJIDsToStringList((Collection<JID>)outcasts));
        mucRoomEntity.setOwnerGroups(MUCRoomUtils.convertGroupsToStringList(owners.getGroups()));
        mucRoomEntity.setAdminGroups(MUCRoomUtils.convertGroupsToStringList(admins.getGroups()));
        mucRoomEntity.setMemberGroups(MUCRoomUtils.convertGroupsToStringList(members.getGroups()));
        mucRoomEntity.setOutcastGroups(MUCRoomUtils.convertGroupsToStringList(outcasts.getGroups()));
        mucRoomEntity.setBroadcastPresenceRoles(MUCRoomUtils.convertRolesToStringList(room.getRolesToBroadcastPresence()));
        mucRoomEntity.setCreationDate(room.getCreationDate());
        mucRoomEntity.setModificationDate(room.getModificationDate());
        return mucRoomEntity;
    }

    private static Collection<JID> setRoles(MUCRoom room, MUCRoomEntity mucRoomEntity) throws ForbiddenException, NotAllowedException, ConflictException {
        ArrayList<JID> allNewAffiliations = new ArrayList<JID>();
        ArrayList affiliationsToReset = new ArrayList();
        affiliationsToReset.addAll(room.getOwners());
        affiliationsToReset.addAll(room.getAdmins());
        affiliationsToReset.addAll(room.getMembers());
        affiliationsToReset.addAll(room.getOutcasts());
        ArrayList<JID> newOwners = new ArrayList<JID>();
        if (mucRoomEntity.getOwners() != null) {
            newOwners.addAll(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getOwners()));
        }
        if (mucRoomEntity.getOwnerGroups() != null) {
            for (String string : mucRoomEntity.getOwnerGroups()) {
                newOwners.add(UserUtils.checkAndGetJID(string));
            }
        }
        affiliationsToReset.removeAll(newOwners);
        newOwners.removeAll(room.getOwners());
        for (JID jID : newOwners) {
            MUCRoomController.log("Adding new 'owner' affiliation for '" + jID + "' to room: " + room.getName());
            room.addOwner(jID, room.getRole());
            allNewAffiliations.add(jID);
        }
        ArrayList<JID> newAdmins = new ArrayList<JID>();
        if (mucRoomEntity.getAdmins() != null) {
            newAdmins.addAll(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getAdmins()));
        }
        if (mucRoomEntity.getAdminGroups() != null) {
            for (String string : mucRoomEntity.getAdminGroups()) {
                newAdmins.add(UserUtils.checkAndGetJID(string));
            }
        }
        affiliationsToReset.removeAll(newAdmins);
        newAdmins.removeAll(room.getAdmins());
        for (JID jID : newAdmins) {
            MUCRoomController.log("Adding new 'admin' affiliation for '" + jID + "' to room: " + room.getName());
            room.addAdmin(jID, room.getRole());
            allNewAffiliations.add(jID);
        }
        ArrayList<JID> arrayList = new ArrayList<JID>();
        if (mucRoomEntity.getMembers() != null) {
            arrayList.addAll(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getMembers()));
        }
        if (mucRoomEntity.getMemberGroups() != null) {
            for (String groupName : mucRoomEntity.getMemberGroups()) {
                arrayList.add(UserUtils.checkAndGetJID(groupName));
            }
        }
        affiliationsToReset.removeAll(arrayList);
        arrayList.removeAll(room.getMembers());
        for (JID newMember : arrayList) {
            MUCRoomController.log("Adding new 'member' affiliation for '" + newMember + "' to room: " + room.getName());
            room.addMember(newMember, null, room.getRole());
            allNewAffiliations.add(newMember);
        }
        ArrayList<JID> arrayList2 = new ArrayList<JID>();
        if (mucRoomEntity.getOutcasts() != null) {
            arrayList2.addAll(MUCRoomUtils.convertStringsToJIDs(mucRoomEntity.getOutcasts()));
        }
        if (mucRoomEntity.getOutcastGroups() != null) {
            for (String groupName : mucRoomEntity.getOutcastGroups()) {
                arrayList2.add(UserUtils.checkAndGetJID(groupName));
            }
        }
        affiliationsToReset.removeAll(arrayList2);
        arrayList2.removeAll(room.getOutcasts());
        for (JID newOutcast : arrayList2) {
            MUCRoomController.log("Adding new 'outcast' affiliation for '" + newOutcast + "' to room: " + room.getName());
            room.addOutcast(newOutcast, null, room.getRole());
            allNewAffiliations.add(newOutcast);
        }
        for (JID affiliationToReset : affiliationsToReset) {
            MUCRoomController.log("Removing old affiliation for '" + affiliationToReset + "' from room: " + room.getName());
            room.addNone(affiliationToReset, room.getRole());
        }
        return allNewAffiliations;
    }

    public Collection<JID> getByAffiliation(@Nonnull String serviceName, @Nonnull String roomName, @Nonnull MUCRole.Affiliation affiliation) throws ServiceException {
        MUCRoom room = MUCRoomController.getRoom(serviceName, roomName);
        switch (affiliation) {
            case admin: {
                return room.getAdmins();
            }
            case member: {
                return room.getMembers();
            }
            case owner: {
                return room.getOwners();
            }
            case outcast: {
                return room.getOutcasts();
            }
        }
        return room.getOccupants().stream().filter(o -> affiliation.equals((Object)o.getAffiliation())).map(MUCRole::getUserAddress).collect(Collectors.toSet());
    }

    public void replaceAffiliatedUsers(@Nonnull String serviceName, @Nonnull String roomName, @Nonnull MUCRole.Affiliation affiliation, boolean sendInvitations, String ... jids) throws ServiceException {
        HashSet<JID> replacements = new HashSet<JID>();
        for (String replacement : jids) {
            try {
                replacements.add(new JID(replacement));
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException("Unable to parse value as jid: " + replacement, roomName, "IllegalArgumentException", Response.Status.BAD_REQUEST, e);
            }
        }
        Collection<JID> oldUsers = this.getByAffiliation(serviceName, roomName, affiliation);
        ArrayList<JID> toAdd = new ArrayList<JID>(replacements);
        toAdd.removeAll(oldUsers);
        ArrayList<JID> toRemove = new ArrayList<JID>(oldUsers);
        toRemove.removeAll(replacements);
        MUCRoom room = MUCRoomController.getRoom(serviceName, roomName);
        try {
            switch (affiliation) {
                case admin: {
                    room.addAdmins(toAdd, room.getRole());
                    break;
                }
                case member: {
                    for (JID add : toAdd) {
                        room.addMember(add, null, room.getRole());
                    }
                    break;
                }
                case owner: {
                    room.addOwners(toAdd, room.getRole());
                    break;
                }
                case outcast: {
                    for (JID add : toAdd) {
                        room.addOutcast(add, null, room.getRole());
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized affiliation: " + affiliation);
                }
            }
            for (JID remove : toRemove) {
                room.addNone(remove, room.getRole());
            }
        }
        catch (ForbiddenException | NotAllowedException e) {
            throw new ServiceException("Forbidden to apply modification to list of " + affiliation, roomName, "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ConflictException e) {
            throw new ServiceException("Could not apply modification to list of " + affiliation, roomName, "NotAllowedException", Response.Status.CONFLICT, e);
        }
        try {
            if (sendInvitations) {
                this.sendInvitationsFromRoom(room, EnumSet.of(affiliation), toAdd, null, true);
            }
        }
        catch (ForbiddenException e) {
            throw new ServiceException("Can not send invitation to newly affiliated " + affiliation + " users or groups", roomName, "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
    }

    public void addAffiliatedUsers(@Nonnull String serviceName, @Nonnull String roomName, @Nonnull MUCRole.Affiliation affiliation, boolean sendInvitations, String ... jids) throws ServiceException {
        HashSet<JID> additions = new HashSet<JID>();
        for (String string : jids) {
            try {
                additions.add(UserUtils.checkAndGetJID(string));
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException("Unable to parse value as jid: " + string, roomName, "IllegalArgumentException", Response.Status.BAD_REQUEST, e);
            }
        }
        Collection<JID> oldUsers = this.getByAffiliation(serviceName, roomName, affiliation);
        ArrayList<JID> toAdd = new ArrayList<JID>(additions);
        toAdd.removeAll(oldUsers);
        MUCRoom room = MUCRoomController.getRoom(serviceName, roomName);
        try {
            switch (affiliation) {
                case admin: {
                    room.addAdmins(toAdd, room.getRole());
                    break;
                }
                case member: {
                    for (JID add : toAdd) {
                        room.addMember(add, null, room.getRole());
                    }
                    break;
                }
                case owner: {
                    room.addOwners(toAdd, room.getRole());
                    break;
                }
                case outcast: {
                    for (JID add : toAdd) {
                        room.addOutcast(add, null, room.getRole());
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized affiliation: " + affiliation);
                }
            }
        }
        catch (ForbiddenException | NotAllowedException throwable) {
            throw new ServiceException("Forbidden to apply modification to list of " + affiliation, roomName, "NotAllowedException", Response.Status.FORBIDDEN, throwable);
        }
        catch (ConflictException conflictException) {
            throw new ServiceException("Could not apply modification to list of " + affiliation, roomName, "NotAllowedException", Response.Status.CONFLICT, conflictException);
        }
        try {
            if (sendInvitations) {
                this.sendInvitationsFromRoom(room, EnumSet.of(affiliation), toAdd, null, true);
            }
        }
        catch (ForbiddenException forbiddenException) {
            throw new ServiceException("Can not send invitation to newly affiliated " + affiliation + " users or groups", roomName, "NotAllowedException", Response.Status.FORBIDDEN, forbiddenException);
        }
    }

    public void deleteAffiliation(String serviceName, String roomName, MUCRole.Affiliation affiliation, String jid) throws ServiceException {
        MUCRoom room = MUCRoomController.getRoom(serviceName, roomName);
        try {
            JID userJid = UserUtils.checkAndGetJID(jid);
            if (affiliation != null && room.getAffiliation(userJid) != affiliation) {
                throw new ConflictException("Entity does not have this affiliation with the room.");
            }
            List addNonePresence = room.addNone(userJid, room.getRole());
            for (Presence presence : addNonePresence) {
                MUCRoomUtils.send(room, (Packet)presence, room.getRole());
            }
        }
        catch (ForbiddenException e) {
            throw new ServiceException("Could not delete affiliation", jid, "NotAllowedException", Response.Status.FORBIDDEN, e);
        }
        catch (ConflictException e) {
            throw new ServiceException("Could not delete affiliation", jid, "NotAllowedException", Response.Status.CONFLICT, e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ServiceException("Could not delete affiliation", jid, "IllegalArgumentException", Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }
}

