/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupAlreadyExistsException;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.rest.entity.GroupEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.openfire.plugin.rest.utils.MUCRoomUtils;
import org.xmpp.packet.JID;

public class GroupController {
    public static final GroupController INSTANCE = new GroupController();

    public static GroupController getInstance() {
        return INSTANCE;
    }

    public List<GroupEntity> getGroups() throws ServiceException {
        Collection groups = GroupManager.getInstance().getGroups();
        ArrayList<GroupEntity> groupEntities = new ArrayList<GroupEntity>();
        for (Group group : groups) {
            GroupEntity groupEntity = new GroupEntity(group.getName(), group.getDescription());
            groupEntities.add(groupEntity);
        }
        return groupEntities;
    }

    public GroupEntity getGroup(String groupName) throws ServiceException {
        Group group;
        try {
            group = GroupManager.getInstance().getGroup(groupName);
        }
        catch (GroupNotFoundException e) {
            throw new ServiceException("Could not find group", groupName, "GroupNotFoundException", Response.Status.NOT_FOUND, e);
        }
        GroupEntity groupEntity = new GroupEntity(group.getName(), group.getDescription());
        groupEntity.setAdmins(MUCRoomUtils.convertJIDsToStringList(group.getAdmins()));
        groupEntity.setMembers(MUCRoomUtils.convertJIDsToStringList(group.getMembers()));
        groupEntity.setShared("onlyGroup".equals(group.getProperties().get((Object)"sharedRoster.showInRoster")));
        return groupEntity;
    }

    public Group createGroup(GroupEntity groupEntity) throws ServiceException {
        Group group;
        if (groupEntity != null && !groupEntity.getName().isEmpty()) {
            try {
                HashSet<JID> newMembers = new HashSet<JID>();
                HashSet<JID> newAdmins = new HashSet<JID>();
                for (String newMember : groupEntity.getMembers()) {
                    try {
                        newMembers.add(newMember.contains("@") ? new JID(newMember) : XMPPServer.getInstance().createJID(newMember, null));
                    }
                    catch (IllegalArgumentException e) {
                        throw new ServiceException("Cannot parse a member value as a JID: " + newMember, groupEntity.getName(), "IllegalArgumentException", Response.Status.BAD_REQUEST, e);
                    }
                }
                for (String newAdmin : groupEntity.getAdmins()) {
                    try {
                        newAdmins.add(newAdmin.contains("@") ? new JID(newAdmin) : XMPPServer.getInstance().createJID(newAdmin, null));
                    }
                    catch (IllegalArgumentException e) {
                        throw new ServiceException("Cannot parse a admin value as a JID: " + newAdmin, groupEntity.getName(), "IllegalArgumentException", Response.Status.BAD_REQUEST, e);
                    }
                }
                group = GroupManager.getInstance().createGroup(groupEntity.getName());
                group.setDescription(groupEntity.getDescription());
                String showInRoster = groupEntity.getShared() != false ? "onlyGroup" : "nobody";
                group.getProperties().put((Object)"sharedRoster.showInRoster", (Object)showInRoster);
                group.getProperties().put((Object)"sharedRoster.displayName", (Object)groupEntity.getName());
                group.getProperties().put((Object)"sharedRoster.groupList", (Object)"");
                Collection members = group.getMembers();
                for (JID newMember : newMembers) {
                    members.add(newMember);
                }
                Collection admins = group.getAdmins();
                for (JID newAdmin : newAdmins) {
                    admins.add(newAdmin);
                }
            }
            catch (GroupAlreadyExistsException e) {
                throw new ServiceException("Could not create a group", groupEntity.getName(), "GroupAlreadyExistsException", Response.Status.CONFLICT, e);
            }
        } else {
            throw new ServiceException("Could not create new group", "groups", "IllegalArgumentException", Response.Status.BAD_REQUEST);
        }
        return group;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Group updateGroup(String groupName, GroupEntity groupEntity) throws ServiceException {
        if (groupEntity == null || groupEntity.getName().isEmpty()) throw new ServiceException("Could not update new group", "groups", "IllegalArgumentException", Response.Status.BAD_REQUEST);
        if (!groupName.equals(groupEntity.getName())) throw new ServiceException("Could not update the group. The group name is different to the payload group name.", groupName + " != " + groupEntity.getName(), "IllegalArgumentException", Response.Status.BAD_REQUEST);
        try {
            HashSet<JID> newMembers = new HashSet<JID>();
            HashSet<JID> newAdmins = new HashSet<JID>();
            Group group = GroupManager.getInstance().getGroup(groupName);
            for (String newMember : groupEntity.getMembers()) {
                try {
                    newMembers.add(newMember.contains("@") ? new JID(newMember) : XMPPServer.getInstance().createJID(newMember, null));
                }
                catch (IllegalArgumentException e) {
                    throw new ServiceException("Cannot parse a member value as a JID: " + newMember, groupEntity.getName(), "IllegalArgumentException", Response.Status.BAD_REQUEST, e);
                }
            }
            for (String newAdmin : groupEntity.getAdmins()) {
                try {
                    newAdmins.add(newAdmin.contains("@") ? new JID(newAdmin) : XMPPServer.getInstance().createJID(newAdmin, null));
                }
                catch (IllegalArgumentException e) {
                    throw new ServiceException("Cannot parse a admin value as a JID: " + newAdmin, groupEntity.getName(), "IllegalArgumentException", Response.Status.BAD_REQUEST, e);
                }
            }
            group.setDescription(groupEntity.getDescription());
            String showInRoster = groupEntity.getShared() != false ? "onlyGroup" : "nobody";
            group.getProperties().put((Object)"sharedRoster.showInRoster", (Object)showInRoster);
            Collection members = group.getMembers();
            Iterator membersIterator = members.iterator();
            while (membersIterator.hasNext()) {
                JID oldMember = (JID)membersIterator.next();
                if (newMembers.contains(oldMember)) {
                    newMembers.remove(oldMember);
                    continue;
                }
                membersIterator.remove();
            }
            for (JID newMember : newMembers) {
                members.add(newMember);
            }
            Collection admins = group.getAdmins();
            Iterator adminsIterator = admins.iterator();
            while (adminsIterator.hasNext()) {
                JID oldAdmin = (JID)adminsIterator.next();
                if (newAdmins.contains(oldAdmin)) {
                    newAdmins.remove(oldAdmin);
                    continue;
                }
                adminsIterator.remove();
            }
            for (JID newAdmin : newAdmins) {
                admins.add(newAdmin);
            }
            return group;
        }
        catch (GroupNotFoundException e) {
            throw new ServiceException("Could not find group", groupName, "GroupNotFoundException", Response.Status.NOT_FOUND, e);
        }
    }

    public void deleteGroup(String groupName) throws ServiceException {
        try {
            Group group = GroupManager.getInstance().getGroup(groupName);
            GroupManager.getInstance().deleteGroup(group);
        }
        catch (GroupNotFoundException e) {
            throw new ServiceException("Could not find group", groupName, "GroupNotFoundException", Response.Status.NOT_FOUND, e);
        }
    }
}

