/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.controller;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.cluster.NodeID;
import org.jivesoftware.openfire.plugin.rest.entity.ClusterNodeEntities;
import org.jivesoftware.openfire.plugin.rest.entity.ClusterNodeEntity;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringController {
    private static final Logger LOG = LoggerFactory.getLogger(ClusteringController.class);
    private static ClusteringController INSTANCE = null;

    public static ClusteringController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClusteringController();
        }
        return INSTANCE;
    }

    @Deprecated
    public static void setInstance(ClusteringController instance) {
        INSTANCE = instance;
    }

    public static void log(String logMessage) {
        if (JiveGlobals.getBooleanProperty((String)"plugin.restapi.serviceLoggingEnabled", (boolean)false)) {
            LOG.info(logMessage);
        }
    }

    public String getClusterStatus() {
        if (ClusterManager.isClusteringEnabled()) {
            if (ClusterManager.isClusteringStarted()) {
                if (ClusterManager.isSeniorClusterMember()) {
                    if (ClusterManager.getNodesInfo().size() == 1) {
                        return "SENIOR AND ONLY MEMBER";
                    }
                    return "Senior member";
                }
                return "Junior member";
            }
            return "Starting up";
        }
        return "Disabled";
    }

    public Optional<ClusterNodeEntity> getNodeEntity(String nodeId) {
        Optional nodeInfo = ClusterManager.getNodeInfo((NodeID)NodeID.getInstance((byte[])nodeId.getBytes(StandardCharsets.UTF_8)));
        return nodeInfo.map(ClusterNodeEntity::from);
    }

    public ClusterNodeEntities getNodeEntities() {
        Collection nodesInfo = ClusterManager.getNodesInfo();
        return new ClusterNodeEntities(nodesInfo.stream().map(ClusterNodeEntity::from).collect(Collectors.toList()));
    }
}

