/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jivesoftware.admin.AuthCheckFilter;
import org.jivesoftware.openfire.MessageRouter;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.event.UserEventDispatcher;
import org.jivesoftware.openfire.event.UserEventListener;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.lockout.LockOutManager;
import org.jivesoftware.openfire.privacy.PrivacyList;
import org.jivesoftware.openfire.privacy.PrivacyListManager;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.util.EmailService;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class RegistrationPlugin
implements Plugin {
    private static final Logger Log = LoggerFactory.getLogger(RegistrationPlugin.class);
    private static final String URL = "registration/sign-up.jsp";
    private static final String IM_NOTIFICATION_ENABLED = "registration.imnotification.enabled";
    private static final String EMAIL_NOTIFICATION_ENABLED = "registration.emailnotification.enabled";
    private static final String WELCOME_ENABLED = "registration.welcome.enabled";
    private static final String GROUP_ENABLED = "registration.group.enabled";
    private static final String PRIVACYLIST_ENABLED = "registration.privacylist.enabled";
    private static final String WEB_ENABLED = "registration.web.enabled";
    private static final String INITIALCONTACTS_ENABLED = "registration.initialcontacts.enabled";
    private static final String INITIAL_CONTACTS = "registration.initialcontacts.imContacts";
    private static final String IM_CONTACTS = "registration.notification.imContacts";
    private static final String EMAIL_CONTACTS = "registration.notification.emailContacts";
    private static final String WELCOME_MSG = "registration.welcome.message";
    private static final String REGISTRATION_GROUP = "registration.group";
    private static final String REGISTRAION_PRIVACYLIST = "registration.privacylist";
    private static final String REGISTRAION_PRIVACYLIST_NAME = "registration.privacylist.name";
    private static final String REGISTRATION_AUTO_LOCKOUT = "registration.automatic.lockout.seconds";
    private static final String HEADER = "registration.header";
    private RegistrationUserEventListener listener = new RegistrationUserEventListener();
    private String serverName;
    private JID serverAddress;
    private MessageRouter router;
    private boolean privacyListCacheIsSet = false;
    private Element privacyListCache = null;
    private List<String> imContacts = new ArrayList<String>();
    private List<String> emailContacts = new ArrayList<String>();
    private List<String> initialContacts = new ArrayList<String>();

    public RegistrationPlugin() {
        String accs;
        String ecs;
        this.serverName = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
        this.serverAddress = new JID(this.serverName);
        this.router = XMPPServer.getInstance().getMessageRouter();
        String imcs = JiveGlobals.getProperty((String)IM_CONTACTS);
        if (imcs != null) {
            this.imContacts.addAll(Arrays.asList(imcs.split(",")));
        }
        if ((ecs = JiveGlobals.getProperty((String)EMAIL_CONTACTS)) != null) {
            this.emailContacts.addAll(Arrays.asList(ecs.split(",")));
        }
        if ((accs = JiveGlobals.getProperty((String)INITIAL_CONTACTS)) != null) {
            this.initialContacts.addAll(Arrays.asList(accs.split(",")));
        }
        UserEventDispatcher.addListener((UserEventListener)this.listener);
        JiveGlobals.deleteProperty((String)"registration.notification.contact");
        JiveGlobals.deleteProperty((String)"registration.notification.enabled");
    }

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        AuthCheckFilter.addExclude((String)URL);
    }

    public void destroyPlugin() {
        AuthCheckFilter.removeExclude((String)URL);
        UserEventDispatcher.removeListener((UserEventListener)this.listener);
        this.serverAddress = null;
        this.listener = null;
        this.router = null;
    }

    public void setIMNotificationEnabled(boolean enable) {
        JiveGlobals.setProperty((String)IM_NOTIFICATION_ENABLED, (String)(enable ? "true" : "false"));
    }

    public boolean imNotificationEnabled() {
        return JiveGlobals.getBooleanProperty((String)IM_NOTIFICATION_ENABLED, (boolean)false);
    }

    public void setEmailNotificationEnabled(boolean enable) {
        JiveGlobals.setProperty((String)EMAIL_NOTIFICATION_ENABLED, (String)(enable ? "true" : "false"));
    }

    public boolean emailNotificationEnabled() {
        return JiveGlobals.getBooleanProperty((String)EMAIL_NOTIFICATION_ENABLED, (boolean)false);
    }

    public void setInitialContactsEnabled(boolean enable) {
        JiveGlobals.setProperty((String)INITIALCONTACTS_ENABLED, (String)(enable ? "true" : "false"));
    }

    public boolean initialContactsEnabled() {
        return JiveGlobals.getBooleanProperty((String)INITIALCONTACTS_ENABLED, (boolean)false);
    }

    public Collection<String> getInitialContacts() {
        Log.debug("Returning all initial contacts.");
        Collections.sort(this.initialContacts);
        return this.initialContacts;
    }

    public void addInitialContact(String contact) {
        Log.debug("Adding a new initial contact: {}", (Object)contact);
        if (!this.initialContacts.contains(contact.trim().toLowerCase())) {
            this.initialContacts.add(contact.trim().toLowerCase());
            JiveGlobals.setProperty((String)INITIAL_CONTACTS, (String)this.propPrep(this.initialContacts));
        }
    }

    public void removeInitialContact(String contact) {
        Log.debug("Removing an initial contact: {}", (Object)contact);
        this.initialContacts.remove(contact.trim().toLowerCase());
        if (this.initialContacts.size() == 0) {
            JiveGlobals.deleteProperty((String)INITIAL_CONTACTS);
        } else {
            JiveGlobals.setProperty((String)IM_CONTACTS, (String)this.propPrep(this.initialContacts));
        }
    }

    public Collection<String> getIMContacts() {
        Collections.sort(this.imContacts);
        return this.imContacts;
    }

    public void addIMContact(String contact) {
        if (!this.imContacts.contains(contact.trim().toLowerCase())) {
            this.imContacts.add(contact.trim().toLowerCase());
            JiveGlobals.setProperty((String)IM_CONTACTS, (String)this.propPrep(this.imContacts));
        }
    }

    public void removeIMContact(String contact) {
        this.imContacts.remove(contact.trim().toLowerCase());
        if (this.imContacts.size() == 0) {
            JiveGlobals.deleteProperty((String)IM_CONTACTS);
        } else {
            JiveGlobals.setProperty((String)IM_CONTACTS, (String)this.propPrep(this.imContacts));
        }
    }

    public Collection<String> getEmailContacts() {
        Collections.sort(this.emailContacts);
        return this.emailContacts;
    }

    public void addEmailContact(String contact) {
        if (!this.emailContacts.contains(contact.trim())) {
            this.emailContacts.add(contact.trim());
            JiveGlobals.setProperty((String)EMAIL_CONTACTS, (String)this.propPrep(this.emailContacts));
        }
    }

    public void removeEmailContact(String contact) {
        this.emailContacts.remove(contact);
        if (this.emailContacts.size() == 0) {
            JiveGlobals.deleteProperty((String)EMAIL_CONTACTS);
        } else {
            JiveGlobals.setProperty((String)EMAIL_CONTACTS, (String)this.propPrep(this.emailContacts));
        }
    }

    public void setWelcomeEnabled(boolean enable) {
        JiveGlobals.setProperty((String)WELCOME_ENABLED, (String)(enable ? "true" : "false"));
    }

    public boolean welcomeEnabled() {
        return JiveGlobals.getBooleanProperty((String)WELCOME_ENABLED, (boolean)false);
    }

    public void setWelcomeMessage(String message) {
        JiveGlobals.setProperty((String)WELCOME_MSG, (String)message);
    }

    public String getWelcomeMessage() {
        return JiveGlobals.getProperty((String)WELCOME_MSG, (String)"Welcome to Openfire!");
    }

    public void setGroupEnabled(boolean enable) {
        JiveGlobals.setProperty((String)GROUP_ENABLED, (String)(enable ? "true" : "false"));
    }

    public boolean groupEnabled() {
        return JiveGlobals.getBooleanProperty((String)GROUP_ENABLED, (boolean)false);
    }

    public void setPrivacyListEnabled(boolean enable) {
        JiveGlobals.setProperty((String)PRIVACYLIST_ENABLED, (String)(enable ? "true" : "false"));
    }

    public boolean privacyListEnabled() {
        return JiveGlobals.getBooleanProperty((String)PRIVACYLIST_ENABLED, (boolean)false);
    }

    public void setWebEnabled(boolean enable) {
        JiveGlobals.setProperty((String)WEB_ENABLED, (String)(enable ? "true" : "false"));
    }

    public boolean webEnabled() {
        return JiveGlobals.getBooleanProperty((String)WEB_ENABLED, (boolean)false);
    }

    public String webRegistrationAddress() {
        return "http://" + XMPPServer.getInstance().getServerInfo().getXMPPDomain() + ":" + JiveGlobals.getXMLProperty((String)"adminConsole.port") + "/plugins/" + URL;
    }

    public void setGroup(String group) {
        JiveGlobals.setProperty((String)REGISTRATION_GROUP, (String)group);
    }

    public String getGroup() {
        return JiveGlobals.getProperty((String)REGISTRATION_GROUP);
    }

    public void setPrivacyList(String privacyList) {
        JiveGlobals.setProperty((String)REGISTRAION_PRIVACYLIST, (String)privacyList);
        this.privacyListCacheIsSet = false;
    }

    public String getPrivacyList() {
        return JiveGlobals.getProperty((String)REGISTRAION_PRIVACYLIST);
    }

    public void setPrivacyListName(String privacyListName) {
        JiveGlobals.setProperty((String)REGISTRAION_PRIVACYLIST_NAME, (String)privacyListName);
    }

    public String getPrivacyListName() {
        return JiveGlobals.getProperty((String)REGISTRAION_PRIVACYLIST_NAME);
    }

    public boolean isAutomaticAccountLockoutEnabled() {
        return this.getAutomaticAccountLockoutAfter() > 0L;
    }

    public void setAutomaticAccountLockoutAfter(long seconds) {
        JiveGlobals.setProperty((String)REGISTRATION_AUTO_LOCKOUT, (String)Long.toString(seconds));
    }

    public long getAutomaticAccountLockoutAfter() {
        return JiveGlobals.getLongProperty((String)REGISTRATION_AUTO_LOCKOUT, (long)-1L);
    }

    public void setHeader(String message) {
        JiveGlobals.setProperty((String)HEADER, (String)message);
    }

    public String getHeader() {
        return JiveGlobals.getProperty((String)HEADER, (String)"Web Sign-In");
    }

    private String propPrep(Collection<String> props) {
        StringBuilder buf = new StringBuilder();
        Iterator<String> iter = props.iterator();
        while (iter.hasNext()) {
            String con = iter.next();
            buf.append(con);
            if (!iter.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public boolean isValidAddress(String address) {
        if (address == null) {
            return false;
        }
        return address.matches(".{1,}[@].{1,}[.].{2,}");
    }

    private class RegistrationUserEventListener
    implements UserEventListener {
        private RegistrationUserEventListener() {
        }

        public void userCreated(User user, Map<String, Object> params) {
            if (Log.isDebugEnabled()) {
                Log.debug("Registration plugin : registering new user");
            }
            if (RegistrationPlugin.this.imNotificationEnabled()) {
                this.sendIMNotificatonMessage(user);
            }
            if (RegistrationPlugin.this.emailNotificationEnabled()) {
                this.sendAlertEmail(user);
            }
            if (RegistrationPlugin.this.welcomeEnabled()) {
                this.sendWelcomeMessage(user);
            }
            if (RegistrationPlugin.this.groupEnabled()) {
                this.addUserToGroup(user);
            }
            if (RegistrationPlugin.this.initialContactsEnabled()) {
                this.addContactToRoster(user);
            }
            if (RegistrationPlugin.this.privacyListEnabled()) {
                this.addDefaultPrivacyList(user);
            }
            if (RegistrationPlugin.this.isAutomaticAccountLockoutEnabled()) {
                this.addAutomaticAccountLockout(user);
            }
        }

        public void userDeleting(User user, Map<String, Object> params) {
        }

        public void userModified(User user, Map<String, Object> params) {
        }

        private void sendIMNotificatonMessage(User user) {
            String msg = " A new user with the username '" + user.getUsername() + "' just registered.";
            for (String contact : RegistrationPlugin.this.getIMContacts()) {
                RegistrationPlugin.this.router.route(this.createServerMessage(contact + "@" + RegistrationPlugin.this.serverName, "Registration Notification", msg));
            }
        }

        private void sendAlertEmail(User user) {
            String subject = "User Registration";
            String body = " A new user with the username '" + user.getUsername() + "' just registered.";
            EmailService emailService = EmailService.getInstance();
            for (String toAddress : RegistrationPlugin.this.emailContacts) {
                try {
                    emailService.sendMessage(null, toAddress, "Openfire", "no_reply@" + RegistrationPlugin.this.serverName, subject, body, null);
                }
                catch (Exception e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        private void sendWelcomeMessage(User user) {
            RegistrationPlugin.this.router.route(this.createServerMessage(user.getUsername() + "@" + RegistrationPlugin.this.serverName, "Welcome", RegistrationPlugin.this.getWelcomeMessage()));
        }

        private Message createServerMessage(String to, String subject, String body) {
            Message message = new Message();
            message.setTo(to);
            message.setFrom(RegistrationPlugin.this.serverAddress);
            if (subject != null) {
                message.setSubject(subject);
            }
            message.setBody(body);
            return message;
        }

        private void addUserToGroup(User user) {
            try {
                GroupManager groupManager = GroupManager.getInstance();
                Group group = groupManager.getGroup(RegistrationPlugin.this.getGroup());
                group.getMembers().add(XMPPServer.getInstance().createJID(user.getUsername(), null));
            }
            catch (GroupNotFoundException e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }

        private void addContactToRoster(User user) {
            Log.debug("registration: Adding all initial contacts to the roster of {}", (Object)user);
            for (String contact : RegistrationPlugin.this.initialContacts) {
                try {
                    RosterItem item = user.getRoster().createRosterItem(new JID(contact), false, true);
                    item.setSubStatus(RosterItem.SUB_TO);
                    user.getRoster().updateRosterItem(item);
                }
                catch (Exception e) {
                    Log.error("An exception occurred while trying to add '{}' as an initial contact to the roster of new user '{}'.", (Object)new Object[]{contact, user}, (Object)e);
                }
            }
        }

        private void addDefaultPrivacyList(User user) {
            if (Log.isDebugEnabled()) {
                Log.debug("Registration plugin : adding default privacy list.");
                Log.debug("\tName = " + RegistrationPlugin.this.getPrivacyListName());
                Log.debug("\tContent = " + RegistrationPlugin.this.getPrivacyList());
            }
            if (!RegistrationPlugin.this.privacyListCacheIsSet) {
                RegistrationPlugin.this.privacyListCacheIsSet = true;
                try {
                    Document document = DocumentHelper.parseText((String)RegistrationPlugin.this.getPrivacyList());
                    RegistrationPlugin.this.privacyListCache = document.getRootElement();
                }
                catch (DocumentException e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
                if (RegistrationPlugin.this.privacyListCache == null) {
                    Log.error("registration.privacylist can not be parsed into a valid privacy list");
                }
            }
            if (RegistrationPlugin.this.privacyListCache != null) {
                PrivacyListManager privacyListManager = PrivacyListManager.getInstance();
                PrivacyList newPrivacyList = privacyListManager.createPrivacyList(user.getUsername(), RegistrationPlugin.this.getPrivacyListName(), RegistrationPlugin.this.privacyListCache);
                privacyListManager.changeDefaultList(user.getUsername(), newPrivacyList, null);
            }
        }

        private void addAutomaticAccountLockout(User user) {
            long start = System.currentTimeMillis() + RegistrationPlugin.this.getAutomaticAccountLockoutAfter() * 1000L;
            LockOutManager.getInstance().disableAccount(user.getUsername(), new Date(start), null);
        }
    }
}

