/*
 * Decompiled with CFR 0.152.
 */
package org.ifsoft.rdp.openfire;

import com.toremote.gateway.SparkGateway;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.http.HttpBindManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImpl
implements Plugin,
PropertyEventListener {
    private static final Logger Log = LoggerFactory.getLogger(PluginImpl.class);
    private ServletContextHandler rdpContext;
    private ExecutorService executor;

    public void destroyPlugin() {
        PropertyEventDispatcher.removeListener((PropertyEventListener)this);
        try {
            SparkGateway.stop();
            this.executor.shutdown();
            HttpBindManager.getInstance().removeJettyHandler((Handler)this.rdpContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initializePlugin(PluginManager manager, final File pluginDirectory) {
        PropertyEventDispatcher.addListener((PropertyEventListener)this);
        boolean rdpEnabled = JiveGlobals.getBooleanProperty((String)"rdp.enabled", (boolean)true);
        if (rdpEnabled) {
            this.executor = Executors.newCachedThreadPool();
            this.executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    Log.info("Starting SparkGateway RDP service");
                    try {
                        String homeFolder = pluginDirectory.getAbsolutePath() + File.separator + "classes" + File.separator;
                        String openfireHome = JiveGlobals.getHomeDirectory() + File.separator;
                        File conf = new File(homeFolder + "gateway.conf");
                        Properties props = new Properties();
                        props.load(new FileInputStream(conf));
                        props.setProperty("html", homeFolder + "html");
                        props.setProperty("logfile", openfireHome + "logs" + File.separator + "rdp.log");
                        SparkGateway.init((Properties)props);
                        SparkGateway.start();
                        PluginImpl.this.addRdpProxy();
                    }
                    catch (Exception e) {
                        Log.error("rdp error", (Throwable)e);
                        Log.info("rdp disabled");
                    }
                    return true;
                }
            });
        } else {
            Log.info("rdp disabled");
        }
    }

    public String getIpAddress() {
        String ourHostname = XMPPServer.getInstance().getServerInfo().getHostname();
        String ourIpAddress = "127.0.0.1";
        try {
            ourIpAddress = InetAddress.getByName(ourHostname).getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ourIpAddress;
    }

    private void addRdpProxy() {
        Log.info("Initialize RdpProxy");
        this.rdpContext = new ServletContextHandler(null, "/rdp", 1);
        ServletHolder proxyServlet = new ServletHolder(ProxyServlet.Transparent.class);
        proxyServlet.setInitParameter("proxyTo", "http://" + this.getIpAddress());
        proxyServlet.setInitParameter("prefix", "/");
        this.rdpContext.addServlet(proxyServlet, "/*");
        HttpBindManager.getInstance().addJettyHandler((Handler)this.rdpContext);
    }

    public void propertySet(String property, Map params) {
    }

    public void propertyDeleted(String property, Map<String, Object> params) {
    }

    public void xmlPropertySet(String property, Map<String, Object> params) {
    }

    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
    }
}

