/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.blacklistspam;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.igniterealtime.openfire.plugin.blacklistspam.Blacklist;
import org.jivesoftware.openfire.interceptor.PacketInterceptor;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Packet;

public class StanzaBlocker
implements PacketInterceptor,
PropertyEventListener {
    private static final Logger Log = LoggerFactory.getLogger(StanzaBlocker.class);
    private Blacklist blacklist;
    private boolean checkIncoming;
    private boolean checkOutgoing;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();

    public StanzaBlocker() {
        this.refreshPropertyValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interceptPacket(Packet packet, Session session, boolean incoming, boolean processed) throws PacketRejectedException {
        block6: {
            this.rwl.readLock().lock();
            try {
                if (this.blacklist == null || packet.getFrom() == null || (!this.checkIncoming || !incoming) && (!this.checkOutgoing || !processed) || !this.blacklist.isOnBlacklist(packet.getFrom())) break block6;
                Log.info("Rejected stanza sent by entity '{}' that is on the blacklist.", (Object)packet.getFrom());
                try {
                    if (JiveGlobals.getBooleanProperty((String)"blacklistspam.blockedlog.enabled", (boolean)false)) {
                        this.store(packet);
                    }
                }
                catch (Exception e) {
                    Log.warn("An unexpected exception occurred while trying to store a rejected stanza.", (Throwable)e);
                }
                throw new PacketRejectedException("Rejected stanza sent by entity '" + packet.getFrom() + "' that is on the blacklist.");
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }
    }

    public void store(Packet stanza) {
        Path logDir = Paths.get(JiveGlobals.getHomeDirectory(), "blacklist", "blocked");
        Instant now = Instant.now();
        String fileName = DateTimeFormatter.BASIC_ISO_DATE.withZone(ZoneId.systemDefault()).format(now).concat(".txt");
        String data = DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.systemDefault()).format(now) + " from [" + stanza.getFrom() + "]: " + stanza.toXML() + System.lineSeparator();
        try {
            Files.createDirectories(logDir, new FileAttribute[0]);
            Files.write(logDir.resolve(fileName), data.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (Exception e) {
            Log.warn("An exception occurred while attempting to store blocked stanza to file.", (Throwable)e);
        }
    }

    public void setBlacklist(Blacklist blacklist) {
        this.rwl.writeLock().lock();
        this.blacklist = blacklist;
        this.rwl.writeLock().unlock();
    }

    protected void refreshPropertyValues() {
        this.rwl.writeLock().lock();
        try {
            this.checkIncoming = JiveGlobals.getBooleanProperty((String)"blacklistspam.check.incoming", (boolean)true);
            this.checkOutgoing = JiveGlobals.getBooleanProperty((String)"blacklistspam.check.outgoing", (boolean)false);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public void propertySet(String property, Map<String, Object> params) {
        if (Arrays.asList("blacklistspam.check.incoming", "blacklistspam.check.outgoing").contains(property)) {
            this.refreshPropertyValues();
        }
    }

    public void propertyDeleted(String property, Map<String, Object> params) {
        if (Arrays.asList("blacklistspam.check.incoming", "blacklistspam.check.outgoing").contains(property)) {
            this.refreshPropertyValues();
        }
    }

    public void xmlPropertySet(String property, Map<String, Object> params) {
        if (Arrays.asList("blacklistspam.check.incoming", "blacklistspam.check.outgoing").contains(property)) {
            this.refreshPropertyValues();
        }
    }

    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
        if (Arrays.asList("blacklistspam.check.incoming", "blacklistspam.check.outgoing").contains(property)) {
            this.refreshPropertyValues();
        }
    }
}

