/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.blacklistspam;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.igniterealtime.openfire.plugin.blacklistspam.Blacklist;
import org.igniterealtime.openfire.plugin.blacklistspam.BlacklistFactory;
import org.igniterealtime.openfire.plugin.blacklistspam.StanzaBlocker;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.interceptor.InterceptorManager;
import org.jivesoftware.openfire.interceptor.PacketInterceptor;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlacklistSpamPlugin
implements Plugin,
PropertyEventListener {
    private static final Logger Log = LoggerFactory.getLogger(BlacklistSpamPlugin.class);
    private StanzaBlocker stanzaBlocker;
    private Timer timer;

    public synchronized void initializePlugin(PluginManager manager, File pluginDirectory) {
        this.stanzaBlocker = new StanzaBlocker();
        PropertyEventDispatcher.addListener((PropertyEventListener)this.stanzaBlocker);
        InterceptorManager.getInstance().addInterceptor((PacketInterceptor)this.stanzaBlocker);
        PropertyEventDispatcher.addListener((PropertyEventListener)this);
        this.rescheduleTask();
    }

    public synchronized void destroyPlugin() {
        PropertyEventDispatcher.removeListener((PropertyEventListener)this);
        if (this.stanzaBlocker != null) {
            InterceptorManager.getInstance().removeInterceptor((PacketInterceptor)this.stanzaBlocker);
            PropertyEventDispatcher.removeListener((PropertyEventListener)this.stanzaBlocker);
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public synchronized void rescheduleTask() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                String urlValue = JiveGlobals.getProperty((String)"blacklistspam.connection.request.url", (String)"https://igniterealtime.org/JabberSPAM/blacklist.txt");
                try {
                    URL url = new URL(urlValue);
                    Blacklist blacklist = BlacklistFactory.fromURL(url);
                    if (blacklist != null) {
                        BlacklistSpamPlugin.this.stanzaBlocker.setBlacklist(blacklist);
                        Log.info("Refreshed blacklist from {}", (Object)url);
                    } else {
                        Log.warn("Failed to refresh blacklist from {}.", (Object)url);
                    }
                }
                catch (MalformedURLException e) {
                    Log.error("Unable to parse value as URL: {}.", (Object)urlValue, (Object)e);
                }
            }
        }, 0L, JiveGlobals.getLongProperty((String)"blacklistspam.refresh.interval", (long)TimeUnit.DAYS.toMillis(1L)));
    }

    public void propertySet(String property, Map<String, Object> params) {
        if (Arrays.asList("blacklistspam.refresh.interval").contains(property)) {
            this.rescheduleTask();
        }
    }

    public void propertyDeleted(String property, Map<String, Object> params) {
        if (Arrays.asList("blacklistspam.refresh.interval").contains(property)) {
            this.rescheduleTask();
        }
    }

    public void xmlPropertySet(String property, Map<String, Object> params) {
        if (Arrays.asList("blacklistspam.refresh.interval").contains(property)) {
            this.rescheduleTask();
        }
    }

    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
        if (Arrays.asList("blacklistspam.refresh.interval").contains(property)) {
            this.rescheduleTask();
        }
    }
}

