/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.openfire.plugin.blacklistspam;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class Blacklist {
    private static final Logger Log = LoggerFactory.getLogger(Blacklist.class);
    private final Set<String> blacklist;

    public Blacklist(Collection<JID> blacklist) {
        if (blacklist == null) {
            throw new IllegalArgumentException("Argument 'blacklist' cannot be null.");
        }
        this.blacklist = blacklist.parallelStream().map(JID::toString).collect(Collectors.toSet());
        Log.debug("Constructed a new blacklist with {} JIDs.", (Object)this.blacklist.size());
    }

    public boolean isOnBlacklist(JID jid) {
        boolean result = this.blacklist.contains(jid.toString()) || this.blacklist.contains(jid.getDomain()) || this.blacklist.contains(jid.toBareJID());
        Log.trace("JID {} on blacklist: {}", (Object)jid, (Object)result);
        return result;
    }
}

