/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.accountaff;

import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.admin.AdminManager;
import org.jivesoftware.openfire.plugin.accountaff.Affiliation;
import org.jivesoftware.openfire.plugin.accountaff.Info;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class InfoDAO {
    private static final Logger Log = LoggerFactory.getLogger(InfoDAO.class);

    public static Info lookup(@Nonnull JID account) {
        Log.trace("Lookup account info of {}", (Object)account);
        if (!XMPPServer.getInstance().isLocal(account)) {
            Log.debug("Unable to lookup account info of {} - it is not an account on this server.", (Object)account);
            return null;
        }
        String username = account.getNode();
        Collection sessions = SessionManager.getInstance().getSessions(username);
        Optional<ClientSession> anonymousSession = sessions.stream().filter(ClientSession::isAnonymousUser).findAny();
        if (anonymousSession.isPresent()) {
            return new Info(Affiliation.anonymous, anonymousSession.get().getCreationDate().toInstant(), null);
        }
        try {
            User registeredUser = UserManager.getInstance().getUser(username);
            boolean isAdmin = AdminManager.getInstance().isUserAdmin(username, true);
            if (isAdmin) {
                return new Info(Affiliation.admin, registeredUser.getCreationDate().toInstant(), null);
            }
            String raaAffPropertyValue = (String)registeredUser.getProperties().get("RAA Affiliation");
            Affiliation affiliation = Affiliation.registered;
            if (raaAffPropertyValue != null) {
                try {
                    Affiliation affiliationProperty = Affiliation.valueOf(raaAffPropertyValue);
                    if (affiliationProperty == Affiliation.anonymous || affiliationProperty == Affiliation.admin) {
                        Log.warn("User '{}' has an extended property 'RAA Affiliation' set to the value of '{}' which is a value that cannot be manually configured. This property is being ignored.", (Object)username, (Object)raaAffPropertyValue);
                    } else {
                        affiliation = affiliationProperty;
                    }
                }
                catch (IllegalArgumentException e) {
                    Log.warn("User '{}' has an extended property 'RAA Affiliation' but it does not match one of the recognized affiliation values. Offending value: {}", new Object[]{username, raaAffPropertyValue, e});
                }
            }
            return new Info(affiliation, registeredUser.getCreationDate().toInstant(), null);
        }
        catch (UserNotFoundException e) {
            return null;
        }
    }
}

