/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.accountaff;

import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.accountaff.Info;
import org.jivesoftware.openfire.plugin.accountaff.InfoDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;

public class IQInfoQueryHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(IQInfoQueryHandler.class);
    private final IQHandlerInfo info = new IQHandlerInfo("query", "urn:xmpp:raa:0");

    public IQInfoQueryHandler() {
        super("Reporting Account Affiliations handler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        Log.trace("Processing RAA IQ stanza from {}", (Object)packet.getFrom());
        if (packet.isResponse()) {
            Log.debug("Silently ignoring IQ response stanza from {}", (Object)packet.getFrom());
            return null;
        }
        IQ reply = IQ.createResultIQ((IQ)packet);
        reply.setChildElement(packet.getChildElement().createCopy());
        if (IQ.Type.set == packet.getType()) {
            Log.debug("Returning error to {}: request is of incorrect IQ type.", (Object)packet.getFrom());
            reply.setError(PacketError.Condition.feature_not_implemented);
            return reply;
        }
        JID target = packet.getTo();
        Log.trace("Processing RAA query request from {} for {}", (Object)packet.getFrom(), (Object)target);
        Info info = InfoDAO.lookup(target);
        if (info == null) {
            Log.trace("Unable to find info for account {}. Returning item-not-found to {}.", (Object)target, (Object)packet.getFrom());
            reply.setError(PacketError.Condition.item_not_found);
        } else {
            Log.trace("Found info for account {}. Returning info to {}: {}", new Object[]{target, packet.getFrom(), info});
            reply.getChildElement().add(info.asElement());
        }
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

