/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.accountaff;

import org.jivesoftware.openfire.interceptor.PacketInterceptor;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.plugin.accountaff.Info;
import org.jivesoftware.openfire.plugin.accountaff.InfoDAO;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class EmbedPresenceSubPacketInterceptor
implements PacketInterceptor {
    private static final Logger Log = LoggerFactory.getLogger(EmbedPresenceSubPacketInterceptor.class);
    public static final String NAMESPACE = "urn:xmpp:raa:0#embed-presence-sub";

    public void interceptPacket(Packet packet, Session session, boolean incoming, boolean processed) throws PacketRejectedException {
        JID originator;
        if (processed) {
            return;
        }
        if (!incoming || !(session instanceof LocalClientSession)) {
            return;
        }
        if (!(packet instanceof Presence) || ((Presence)packet).getType() != Presence.Type.subscribe) {
            return;
        }
        boolean didRemoveSomething = packet.deleteExtension("info", "urn:xmpp:raa:0");
        if (didRemoveSomething) {
            Log.info("Prevented RAA spoofing: Removed RAA 'info' extension from presence stanza of type {} sent by {} addressed to: {}", new Object[]{((Presence)packet).getType(), packet.getFrom(), packet.getTo()});
        }
        if ((originator = packet.getFrom()) == null) {
            Log.warn("Unable to process presence subscription stanza, as the stanza has no 'from' attribute: {}", (Object)packet);
        } else {
            Log.trace("Attempting to add info to presence subscription stanza for user '{}'", (Object)originator);
            Info info = InfoDAO.lookup(originator);
            if (info != null) {
                packet.getElement().add(info.asElement());
            }
        }
    }
}

