/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountUpDownLatch {
    private final Sync sync;

    public CountUpDownLatch() {
        this(0);
    }

    public CountUpDownLatch(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this.sync = new Sync(n);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, timeUnit.toNanos(l));
    }

    public boolean countUp() {
        return this.sync.countUp();
    }

    public boolean countUp(int n) {
        return this.sync.countUp(n);
    }

    public boolean countDown() {
        return this.sync.countDown();
    }

    public boolean countDown(int n) {
        return this.sync.countDown(n);
    }

    public int getCount() {
        return this.sync.getCount();
    }

    public boolean setCount(int n) {
        return this.sync.setCount(n);
    }

    public String toString() {
        return String.format("%s[count=%d]", super.toString(), this.sync.getCount());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(CountUpDownLatch countUpDownLatch) {
        return this == countUpDownLatch;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 7224851200740908493L;

        Sync(int n) {
            this.setState(n);
        }

        @Override
        protected boolean tryReleaseShared(int n) {
            return n == 0;
        }

        int getCount() {
            return this.getState();
        }

        @Override
        protected int tryAcquireShared(int n) {
            return this.getState() == 0 ? 1 : -1;
        }

        boolean setCount(int n) {
            int n2;
            if (n < 0) {
                throw new IllegalArgumentException(String.format("amount must be non-negative: %d", n));
            }
            boolean bl = n == 0;
            do {
                n2 = this.getState();
                if (!bl || n2 != 0) continue;
                return false;
            } while (!this.compareAndSetState(n2, n));
            return bl ? this.releaseShared(0) : false;
        }

        boolean countDown() {
            int n;
            int n2;
            do {
                if ((n2 = this.getState()) != 0) continue;
                return false;
            } while (!super.compareAndSetState(n2, n = n2 - 1));
            if (n == 0) {
                return this.releaseShared(0);
            }
            return false;
        }

        boolean countDown(int n) {
            int n2;
            int n3;
            if (n < 1) {
                throw new IllegalArgumentException(String.format("Amount must be positive: %d", n));
            }
            do {
                if ((n3 = this.getState()) != 0) continue;
                return false;
            } while (!super.compareAndSetState(n3, n2 = n >= n3 ? 0 : n3 - n));
            return n2 == 0 ? this.releaseShared(0) : false;
        }

        boolean countUp() {
            int n;
            int n2;
            do {
                if ((n2 = this.getState()) != Integer.MAX_VALUE) continue;
                throw new ArithmeticException(String.format("integer overflow: %d + 1", n2));
            } while (!super.compareAndSetState(n2, n = n2 + 1));
            return n2 == 0;
        }

        boolean countUp(int n) {
            int n2;
            int n3;
            if (n < 1) {
                throw new IllegalArgumentException(String.format("amount must be positive: %d", n));
            }
            do {
                if (n <= Integer.MAX_VALUE - (n3 = this.getState())) continue;
                throw new ArithmeticException(String.format("integer overflow: %d + $d", n3, n));
            } while (!super.compareAndSetState(n3, n2 = n3 + n));
            return n3 == 0;
        }
    }
}

